FIELDEFFECTS = {
	PBFields::NONE => { #can also be used as a prototype!
		:FIELDNAME => nil,
		:INTROMESSAGE => nil,
		:FIELDGRAPHICS => "IndoorA",
		:SECRETPOWERANIM => PBMoves::TRIATTACK,
		:NATUREMOVES => PBMoves::TRIATTACK,
		:MIMICRY => PBTypes::NORMAL,
		:MOVEDAMAGEBOOST => {},
		:MOVEMESSAGES => {},
		:MOVETYPEMOD => {},
		:MOVETYPECHANGE => {},
		:MOVEACCURACYBOOST => {},
		:TYPEDAMAGEBOOST => {},
		:TYPEMESSAGES => {},
		:TYPECONDITION => {},
		:TYPETYPEMOD => {}, #type modifier based on original type
		:TYPETYPECHANGE => {},
		:FIELDCHANGE => {},
		:DONTCHANGEBACKUP => [],
		:CHANGEMESSAGE => {},
		:CHANGECONDITION => {},
		:CHANGEEFFECTS => {},
		:SEED => nil,
		:SEEDEFFECT => nil,
		:SEEDEFFECTVAL => nil,
		:SEEDEFFECTSTR => nil,
		:SEEDANIM => nil,
		:SEEDSTATS => {}
		},
	# 1 Electric Terrain
	PBFields::ELECTRICT => {
		:FIELDNAME => "Electric Terrain",
		:INTROMESSAGE => "The field is hyper-charged!",
		:FIELDGRAPHICS => "Electric",
		:SECRETPOWERANIM => PBMoves::SHOCKWAVE,
		:NATUREMOVES => PBMoves::THUNDERBOLT,
		:MIMICRY => PBTypes::ELECTRIC,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::EXPLOSION, PBMoves::SELFDESTRUCT, PBMoves::HURRICANE, PBMoves::SURF,
						PBMoves::SMACKDOWN, PBMoves::MUDDYWATER, PBMoves::THOUSANDARROWS],
		2.0 => [PBMoves::MAGNETBOMB]},
		:MOVEMESSAGES => {
		"The explosion became hyper-charged!" => [PBMoves::EXPLOSION, PBMoves::SELFDESTRUCT],
		"The attack became hyper-charged!" => [PBMoves::HURRICANE, PBMoves::SURF, 
			PBMoves::SMACKDOWN, PBMoves::MUDDYWATER, PBMoves::THOUSANDARROWS],
		"The attack powered up!" => [PBMoves::MAGNETBOMB]},
		:MOVETYPEMOD => {
		PBTypes::ELECTRIC => [PBMoves::EXPLOSION, PBMoves::SELFDESTRUCT, PBMoves::SMACKDOWN, 
			PBMoves::SURF, PBMoves::MUDDYWATER, PBMoves::HURRICANE, PBMoves::THOUSANDARROWS, PBMoves::HYDROVORTEX]},
		:MOVEACCURACYBOOST => {},
		:TYPEDAMAGEBOOST => {1.5 => [PBTypes::ELECTRIC]},
		:TYPEMESSAGES => {"The Electric Terrain strengthened the attack!" => [PBTypes::ELECTRIC]},
		:TYPECONDITION => {PBTypes::ELECTRIC => "!attacker.isAirborne?" },
		:FIELDCHANGE => {0 => [PBMoves::MUDSPORT, PBMoves::TECTONICRAGE]},
		:CHANGEMESSAGE => {"The hyper-charged terrain shorted out!" => [PBMoves::MUDSPORT, PBMoves::TECTONICRAGE]},
		:STATUSMOVEBOOST => [PBMoves::CHARGE, PBMoves::EERIEIMPULSE,PBMoves::MAGNETRISE],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::ELEMENTALSEED,
		:SEEDEFFECT => PBEffects::Charge,
		:SEEDEFFECTVAL => 2,
		:SEEDEFFECTSTR => "{1} began charging power!",
		:SEEDANIM => PBMoves::CHARGE,
		:SEEDSTATS => {PBStats::SPEED => 1}
		},
	# 2 Grassy Terrain
	PBFields::GRASSYT => {
		:FIELDNAME => "Grassy Terrain",
		:INTROMESSAGE => "The field is in full bloom.",
		:FIELDGRAPHICS =>  "Grassy",
		:SECRETPOWERANIM => PBMoves::SEEDBOMB,
		:NATUREMOVES => PBMoves::ENERGYBALL,
		:MIMICRY => PBTypes::GRASS,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::FAIRYWIND, PBMoves::SILVERWIND],
		0.5 => [PBMoves::MUDDYWATER, PBMoves::SURF, PBMoves::EARTHQUAKE,
						PBMoves::MAGNITUDE, PBMoves::BULLDOZE]
		},
		:MOVEACCURACYBOOST => {80 => [PBMoves::GRASSWHISTLE]},
		:MOVEMESSAGES => {
		"The wind picked up strength from the field!" => [PBMoves::FAIRYWIND, PBMoves::SILVERWIND],
		"The grass softened the attack..." => [PBMoves::MUDDYWATER, PBMoves::SURF, 
			PBMoves::EARTHQUAKE, PBMoves::MAGNITUDE, PBMoves::BULLDOZE]},
		:TYPEDAMAGEBOOST => {1.5 => [PBTypes::GRASS,PBTypes::FIRE]},
		:TYPEMESSAGES => {
		"The Grassy Terrain strengthened the attack!" => [PBTypes::GRASS],
		"The grass below caught flame!" => [PBTypes::FIRE]},
		:TYPECONDITION => {
			PBTypes::GRASS => "!attacker.isAirborne?",
			PBTypes::FIRE =>  "!opponent.isAirborne?"
		},
		:FIELDCHANGE => {
		PBFields::BURNINGF => PBFields::IGNITEMOVES,
		PBFields::CORROSIVEF => [PBMoves::SLUDGEWAVE, PBMoves::ACIDDOWNPOUR]},
		:DONTCHANGEBACKUP => PBFields::IGNITEMOVES + [PBMoves::SLUDGEWAVE, PBMoves::ACIDDOWNPOUR],
		:CHANGEMESSAGE => {
		"The grassy terrain caught fire!" => PBFields::IGNITEMOVES,
		"The grassy terrain was corroded!" => [PBMoves::SLUDGEWAVE, PBMoves::ACIDDOWNPOUR]},
		:CHANGECONDITION => {PBFields::BURNINGF => "ignitecheck"},
		:STATUSMOVEBOOST => [PBMoves::COIL,PBMoves::GROWTH,PBMoves::FLORALHEALING,PBMoves::GRASSWHISTLE],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::ELEMENTALSEED,
		:SEEDEFFECT => PBEffects::Ingrain,
		:SEEDEFFECTVAL => true,
		:SEEDEFFECTSTR => "{1} planted its roots!",
		:SEEDANIM => PBMoves::INGRAIN,
		:SEEDSTATS => {PBStats::DEFENSE => 1}
		},
	# 3 Misty Terrain
	PBFields::MISTYT => {
		:FIELDNAME => "Misty Terrain",
		:INTROMESSAGE => "Mist settles on the field.",
		:FIELDGRAPHICS =>  "Misty",
		:SECRETPOWERANIM => PBMoves::MISTBALL,
		:NATUREMOVES => PBMoves::MISTBALL,
		:MIMICRY => PBTypes::FAIRY,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::FAIRYWIND, PBMoves::MYSTICALFIRE, PBMoves::MOONBLAST, 
						PBMoves::MAGICALLEAF, PBMoves::DOOMDUMMY, PBMoves::ICYWIND,
						PBMoves::MISTBALL, PBMoves::AURASPHERE, PBMoves::STEAMERUPTION, 
						PBMoves::DAZZLINGGLEAM, PBMoves::SILVERWIND, PBMoves::MOONGEISTBEAM],
		0.5 => [PBMoves::DARKPULSE, PBMoves::SHADOWBALL, PBMoves::NIGHTDAZE]},
		:MOVEMESSAGES => {
		"The mist's energy strengthened the attack!" => [PBMoves::FAIRYWIND, PBMoves::MYSTICALFIRE, 
			PBMoves::MOONBLAST, PBMoves::MAGICALLEAF, PBMoves::DOOMDUMMY, PBMoves::ICYWIND, 
			PBMoves::MISTBALL, PBMoves::AURASPHERE, PBMoves::STEAMERUPTION, PBMoves::DAZZLINGGLEAM, 
			PBMoves::SILVERWIND, PBMoves::MOONGEISTBEAM],
		"The mist softened the attack..." => [PBMoves::DARKPULSE, PBMoves::SHADOWBALL, PBMoves::NIGHTDAZE]},
		:TYPEDAMAGEBOOST => {0.5 => [PBTypes::DRAGON]},
		:TYPEMESSAGES => {"The Misty Terrain weakened the attack!" => [PBTypes::DRAGON]},
		:FIELDCHANGE => {0 => PBFields::BLOWMOVES},
		:CHANGEMESSAGE => {"The mist was blown away!" => PBFields::BLOWMOVES},
		:STATUSMOVEBOOST => [PBMoves::COSMICPOWER, PBMoves::AROMATICMIST, PBMoves::SWEETSCENT],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::ELEMENTALSEED,
		:SEEDEFFECT => PBEffects::Wish,
		:SEEDEFFECTVAL => 2,
		:SEEDEFFECTSTR => "A wish was made for {1}!",
		:SEEDANIM => PBMoves::WISH,
		:SEEDSTATS => {PBStats::SPDEF => 1}
		},
	# 4 Dark Crystal Cavern
	PBFields::DARKCRYSTALC => {
		:FIELDNAME => "Dark Crystal Cavern",
		:INTROMESSAGE => "Darkness is gathering...",
		:FIELDGRAPHICS => "DarkCrystalCavern",
		:SECRETPOWERANIM => PBMoves::DARKPULSE,
		:NATUREMOVES => PBMoves::DARKPULSE,
		:MIMICRY => PBTypes::DARK,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::DARKPULSE, PBMoves::NIGHTDAZE, PBMoves::NIGHTSLASH,
						PBMoves::SHADOWBALL, PBMoves::SHADOWPUNCH, PBMoves::SHADOWCLAW, 
						PBMoves::SHADOWSNEAK, PBMoves::SHADOWFORCE, PBMoves::SHADOWBONE, 
						PBMoves::AURORABEAM, PBMoves::SIGNALBEAM, PBMoves::FLASHCANNON, 
						PBMoves::LUSTERPURGE, PBMoves::DAZZLINGGLEAM, PBMoves::MIRRORSHOT, 
						PBMoves::TECHNOBLAST, PBMoves::DOOMDUMMY, PBMoves::POWERGEM, 
						PBMoves::MOONGEISTBEAM, PBMoves::PHOTONGEYSER, PBMoves::DIAMONDSTORM,
						PBMoves::MENACINGMOONRAZEMAELSTROM],
		2.0 => [PBMoves::PRISMATICLASER, PBMoves::BLACKHOLEECLIPSE],
		0.5 => [PBMoves::LIGHTTHATBURNSTHESKY]},
		:MOVEACCURACYBOOST => {100 => [PBMoves::DARKVOID]},
		:MOVEMESSAGES => {
		"The darkness began to gather...!" => [PBMoves::DARKPULSE, PBMoves::NIGHTDAZE, PBMoves::NIGHTSLASH],
		"The darkness strengthened the attack!"	=> [PBMoves::SHADOWBALL, PBMoves::SHADOWPUNCH, 
			PBMoves::SHADOWCLAW, PBMoves::SHADOWSNEAK, PBMoves::SHADOWFORCE, PBMoves::SHADOWBONE,
			PBMoves::MENACINGMOONRAZEMAELSTROM], 
		"The crystals' light strengthened the attack!" =>	[PBMoves::AURORABEAM, 
			PBMoves::SIGNALBEAM, PBMoves::FLASHCANNON, PBMoves::LUSTERPURGE, 
			PBMoves::DAZZLINGGLEAM, PBMoves::MIRRORSHOT, PBMoves::TECHNOBLAST, 
			PBMoves::DOOMDUMMY, PBMoves::POWERGEM, PBMoves::MOONGEISTBEAM, 
			PBMoves::PHOTONGEYSER, PBMoves::DIAMONDSTORM],
		"The crystal split the attack!" => [PBMoves::PRISMATICLASER], 
		"The consuming darkness fed the attack!" => [PBMoves::BLACKHOLEECLIPSE],
		"{1} couldn't consume much light..." => [PBMoves::LIGHTTHATBURNSTHESKY]},
		:FIELDCHANGE => {
			PBFields::CAVE => PBFields::QUAKEMOVES,
			PBFields::CRYSTALC => [PBMoves::SUNNYDAY]},
		:DONTCHANGEBACKUP => [PBMoves::SUNNYDAY],
		:CHANGEMESSAGE => {
			"The dark crystals were shattered!" => PBFields::QUAKEMOVES,
			"The sun lit up the crystal cavern!" => [PBMoves::SUNNYDAY]},
		:CHANGECONDITION => {PBFields::CRYSTALC => "suncheck"},
		:STATUSMOVEBOOST => [PBMoves::FLASH, PBMoves::DARKVOID, PBMoves::MOONLIGHT],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::MAGICALSEED,
		:SEEDEFFECT => PBEffects::MagicCoat,
		:SEEDEFFECTVAL => true,
		:SEEDEFFECTSTR => "{1} shrouded itself with Magic Coat!",
		:SEEDANIM => PBMoves::MAGICCOAT,
		:SEEDSTATS => {PBStats::SPDEF => 1}
		},
	# 5 Chess Board
	PBFields::CHESSB => {
		:FIELDNAME => "Chess Board",
		:INTROMESSAGE => "Opening variation set.",
		:FIELDGRAPHICS =>  "Chess",
		:SECRETPOWERANIM => PBMoves::FEINT,
		:NATUREMOVES => PBMoves::ANCIENTPOWER,
		:MIMICRY => PBTypes::PSYCHIC,
		:MOVEDAMAGEBOOST => {1.5 => [PBMoves::FEINT, PBMoves::FEINTATTACK, PBMoves::FAKEOUT, PBMoves::SUCKERPUNCH, 
			PBMoves::FIRSTIMPRESSION, PBMoves::SHADOWSNEAK, PBMoves::SMARTSTRIKE] + PBFields::CHESSMOVES},
		:MOVEMESSAGES => {"En passant!" => [PBMoves::FEINT, PBMoves::FEINTATTACK, PBMoves::FAKEOUT,
			PBMoves::SUCKERPUNCH, PBMoves::FIRSTIMPRESSION, PBMoves::SHADOWSNEAK, PBMoves::SMARTSTRIKE]},
		:MOVETYPEMOD => {PBTypes::ROCK => PBFields::CHESSMOVES},
		:FIELDCHANGE => {0 => [PBMoves::STOMPINGTANTRUM, PBMoves::TECTONICRAGE]},
		:CHANGEMESSAGE => {"The board was destroyed!" => [PBMoves::STOMPINGTANTRUM, PBMoves::TECTONICRAGE]},
		:STATUSMOVEBOOST => [PBMoves::CALMMIND, PBMoves::NASTYPLOT, PBMoves::TRICKROOM],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::SYNTHETICSEED,
		:SEEDEFFECT => PBEffects::MagicCoat,
		:SEEDEFFECTVAL => true,
		:SEEDEFFECTSTR => "{1} shrouded itself with Magic Coat!",
		:SEEDANIM => PBMoves::MAGICCOAT,
		:SEEDSTATS => {PBStats::SPATK => 1}
		},
	# 6 Big Top Arena
	PBFields::BIGTOPA => {
		:FIELDNAME => "Big Top Arena",
		:INTROMESSAGE => "Now presenting...!",
		:FIELDGRAPHICS =>  "BigTop",
		:SECRETPOWERANIM => PBMoves::DYNAMICPUNCH,
		:NATUREMOVES => PBMoves::ACROBATICS,
		:MIMICRY => PBTypes::NORMAL,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::VINEWHIP, PBMoves::POWERWHIP, PBMoves::FIRELASH, 
						PBMoves::FIERYDANCE, PBMoves::PETALDANCE, PBMoves::REVELATIONDANCE, 
						PBMoves::FLY, PBMoves::ACROBATICS, PBMoves::FIRSTIMPRESSION],
		2.0 => [PBMoves::PAYDAY]},
		:MOVEACCURACYBOOST => {100 => [PBMoves::SING]},
		:MOVEMESSAGES => {
		"Back, foul beast!" => [PBMoves::VINEWHIP, PBMoves::POWERWHIP, PBMoves::FIRELASH], 
		"What grace!" => [PBMoves::FIERYDANCE, PBMoves::PETALDANCE, PBMoves::REVELATIONDANCE], 
		"An extravagant aerial finish!" => [PBMoves::FLY, PBMoves::ACROBATICS], 
		"And what an entrance it is!" => [PBMoves::FIRSTIMPRESSION],
		"And a little extra for you, darling!" => [PBMoves::PAYDAY]},
		:STATUSMOVEBOOST => [PBMoves::ENCORE, PBMoves::DRAGONDANCE, PBMoves::QUIVERDANCE, PBMoves::SWORDSDANCE,
			PBMoves::SING, PBMoves::RAINDANCE, PBMoves::BELLYDRUM, PBMoves::SPOTLIGHT],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::SYNTHETICSEED,
		:SEEDEFFECT => PBEffects::HelpingHand,
		:SEEDEFFECTVAL => true,
		:SEEDEFFECTSTR => "{1} accepts the crowd's help!",
		:SEEDANIM => PBMoves::HELPINGHAND,
		:SEEDSTATS => {PBStats::ATTACK => 1}
		},
	# 7 Burning Field
	PBFields::BURNINGF => {
		:FIELDNAME => "Burning Field",
		:INTROMESSAGE => "The field is ablaze!",
		:FIELDGRAPHICS =>  "Burning",
		:SECRETPOWERANIM => PBMoves::FLAMETHROWER,
		:NATUREMOVES => PBMoves::FLAMETHROWER,
		:MIMICRY => PBTypes::FIRE,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::SMOG, PBMoves::CLEARSMOG],
		2.0 => [PBMoves::SMACKDOWN, PBMoves::THOUSANDARROWS]},
		:MOVEACCURACYBOOST => {100 => [PBMoves::WILLOWISP]},
		:MOVEMESSAGES => {
		"The flames spread from the attack!" => [PBMoves::SMOG, PBMoves::CLEARSMOG],
		"{1} was knocked into the flames!" => [PBMoves::SMACKDOWN, PBMoves::THOUSANDARROWS]},
		:MOVETYPEMOD => {
		PBTypes::FIRE => [PBMoves::SMACKDOWN, PBMoves::SMOG,
											PBMoves::CLEARSMOG, PBMoves::THOUSANDARROWS]},
		:TYPEDAMAGEBOOST => {
		1.5 => [PBTypes::FIRE],
		0.5 => [PBTypes::GRASS,PBTypes::ICE]},
		:TYPEMESSAGES => {
		"The blaze amplified the attack!" => [PBTypes::FIRE],
    	"The blaze softened the attack..." => [PBTypes::GRASS,PBTypes::ICE]},
    	:TYPECONDITION => {
			PBTypes::FIRE =>  "!attacker.isAirborne?",
			PBTypes::GRASS => "!opponent.isAirborne?"
		},
		:FIELDCHANGE => {
		0 => PBFields::BLOWMOVES + [PBMoves::WATERSPORT,PBMoves::SURF, PBMoves::MUDDYWATER, 
		PBMoves::WATERSPOUT, PBMoves::WATERPLEDGE, PBMoves::SPARKLINGARIA, 
		PBMoves::SLUDGEWAVE, PBMoves::SANDTOMB, PBMoves::CONTINENTALCRUSH, PBMoves::HYDROVORTEX, PBMoves::OCEANICOPERETTA]},
		:CHANGEMESSAGE => {
		"The grime snuffed out the flame!" => [PBMoves::SLUDGEWAVE],
		"The wind snuffed out the flame!" => PBFields::BLOWMOVES,
		"The water snuffed out the flame!" => [PBMoves::WATERSPORT,PBMoves::SURF, 
			PBMoves::MUDDYWATER, PBMoves::WATERSPOUT, PBMoves::WATERPLEDGE, 
			PBMoves::SPARKLINGARIA, PBMoves::HYDROVORTEX, PBMoves::OCEANICOPERETTA],
		"The sand snuffed out the flame!" => [PBMoves::SANDTOMB, PBMoves::CONTINENTALCRUSH]},
		:STATUSMOVEBOOST => [PBMoves::WILLOWISP, PBMoves::SMOKESCREEN],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::ELEMENTALSEED,
		:SEEDEFFECT => PBEffects::MultiTurnAttack,
		:SEEDEFFECTVAL => PBMoves::FIRESPIN,
		:SEEDEFFECTSTR => "{1} was trapped in the vortex!",
		:SEEDANIM => PBMoves::FIRESPIN,
		:SEEDSTATS => {PBStats::ATTACK => 1, PBStats::SPATK => 1, PBStats::SPEED => 1}
		},
	# 8 Swamp Field
	PBFields::SWAMPF => {
		:FIELDNAME => "Swamp Field",
		:INTROMESSAGE => "The field is swamped.",
		:FIELDGRAPHICS =>  "Swamp",
		:SECRETPOWERANIM => PBMoves::MUDDYWATER,
		:NATUREMOVES => PBMoves::MUDDYWATER,
		:MIMICRY => PBTypes::WATER,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::MUDBOMB, PBMoves::MUDSHOT, PBMoves::MUDSLAP, PBMoves::MUDDYWATER, 
						PBMoves::SURF, PBMoves::SLUDGEWAVE, PBMoves::GUNKSHOT, PBMoves::BRINE, 
						PBMoves::SMACKDOWN, PBMoves::THOUSANDARROWS, PBMoves::HYDROVORTEX],
		0.25 => [PBMoves::EARTHQUAKE, PBMoves::MAGNITUDE, PBMoves::BULLDOZE]},
		:MOVEACCURACYBOOST => {100 => [PBMoves::SLEEPPOWDER]},
		:MOVEMESSAGES => {
		"The murk strengthened the attack!" => [PBMoves::MUDBOMB, PBMoves::MUDSHOT, 
			PBMoves::MUDSLAP, PBMoves::MUDDYWATER, PBMoves::SURF, PBMoves::SLUDGEWAVE, 
			PBMoves::GUNKSHOT, PBMoves::BRINE, PBMoves::SMACKDOWN, PBMoves::THOUSANDARROWS, PBMoves::HYDROVORTEX],
		"The attack dissipated in the soggy ground..." => [PBMoves::EARTHQUAKE, 
			PBMoves::MAGNITUDE, PBMoves::BULLDOZE]},
		:MOVETYPEMOD => {PBTypes::WATER => [PBMoves::SMACKDOWN, PBMoves::THOUSANDARROWS]},
		:TYPEDAMAGEBOOST => {1.5 => [PBTypes::POISON]},
		:TYPEMESSAGES => {"The poison infected the nearby murk!" => [PBTypes::POISON]},
		:TYPECONDITION => {PBTypes::POISON => "!opponent.isAirborne?" },
		:STATUSMOVEBOOST => [PBMoves::SLEEPPOWDER, PBMoves::AQUARING],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::TELLURICSEED,
		:SEEDEFFECT => PBEffects::Ingrain,
		:SEEDEFFECTVAL => true,
		:SEEDEFFECTSTR => "{1} planted its roots!",
		:SEEDANIM => PBMoves::INGRAIN,
		:SEEDSTATS => {PBStats::DEFENSE => 1,PBStats::SPDEF => 1}
		},
	# 9 Rainbow Field
	PBFields::RAINBOWF => {
		:FIELDNAME => "Rainbow Field",
		:INTROMESSAGE => "What does it mean?",
		:FIELDGRAPHICS =>  "Rainbow",
		:SECRETPOWERANIM => PBMoves::AURORABEAM,
		:NATUREMOVES => PBMoves::AURORABEAM,
		:MIMICRY => PBTypes::DRAGON,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::SILVERWIND, PBMoves::MYSTICALFIRE, PBMoves::DRAGONPULSE, 
					PBMoves::TRIATTACK, PBMoves::SACREDFIRE, PBMoves::FIREPLEDGE, 
					PBMoves::WATERPLEDGE, PBMoves::GRASSPLEDGE, PBMoves::AURORABEAM, 
					PBMoves::JUDGMENT, PBMoves::RELICSONG, PBMoves::HIDDENPOWER, 
					PBMoves::SECRETPOWER, PBMoves::WEATHERBALL, PBMoves::MISTBALL, 
					PBMoves::HEARTSTAMP, PBMoves::MOONBLAST, PBMoves::ZENHEADBUTT, 
					PBMoves::SPARKLINGARIA, PBMoves::FLEURCANNON, PBMoves::PRISMATICLASER, PBMoves::TWINKLETACKLE,
					PBMoves::OCEANICOPERETTA, PBMoves::SOLARBEAM, PBMoves::SOLARBLADE, PBMoves::DAZZLINGGLEAM],
		0.5 => [PBMoves::DARKPULSE, PBMoves::SHADOWBALL, PBMoves::NIGHTDAZE, PBMoves::NEVERENDINGNIGHTMARE]},
		:MOVEMESSAGES => {
		"The attack was rainbow-charged!" => [PBMoves::SILVERWIND, PBMoves::MYSTICALFIRE, 
			PBMoves::DRAGONPULSE, PBMoves::TRIATTACK, PBMoves::SACREDFIRE, PBMoves::FIREPLEDGE, 
			PBMoves::WATERPLEDGE, PBMoves::GRASSPLEDGE, PBMoves::AURORABEAM, PBMoves::JUDGMENT, 
			PBMoves::RELICSONG, PBMoves::HIDDENPOWER, PBMoves::SECRETPOWER, PBMoves::WEATHERBALL, 
			PBMoves::MISTBALL, PBMoves::HEARTSTAMP, PBMoves::MOONBLAST, PBMoves::ZENHEADBUTT, 
			PBMoves::SPARKLINGARIA, PBMoves::FLEURCANNON, PBMoves::PRISMATICLASER, PBMoves::TWINKLETACKLE,
			PBMoves::OCEANICOPERETTA, PBMoves::SOLARBEAM, PBMoves::SOLARBLADE, PBMoves::DAZZLINGGLEAM],
		"The rainbow softened the attack..." => [PBMoves::DARKPULSE, PBMoves::SHADOWBALL, 
			PBMoves::NIGHTDAZE, PBMoves::NEVERENDINGNIGHTMARE]},
		:TYPEDAMAGEBOOST => {1.5 => [PBTypes::NORMAL]},
		:TYPEMESSAGES => {"The rainbow energized the attack!" => [PBTypes::NORMAL]},
		:TYPECONDITION => {PBTypes::NORMAL => "self.pbIsSpecial?(type)" },
		:FIELDCHANGE => {0 => [PBMoves::LIGHTTHATBURNSTHESKY]},
		:CHANGEMESSAGE => {"The rainbow was consumed!" => [PBMoves::LIGHTTHATBURNSTHESKY]},
		:STATUSMOVEBOOST => [PBMoves::COSMICPOWER, PBMoves::MEDITATE, PBMoves::WISH],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::MAGICALSEED,
		:SEEDEFFECT => PBEffects::Wish,
		:SEEDEFFECTVAL => 2,
		:SEEDEFFECTSTR => "A wish was made for {1}!",
		:SEEDANIM => PBMoves::WISH,
		:SEEDSTATS => {PBStats::SPATK => 1}
		},
	# 10 Corrosive Field
	PBFields::CORROSIVEF => {
		:FIELDNAME => "Corrosive Field",
		:INTROMESSAGE => "The field is corrupted!",
		:FIELDGRAPHICS =>  "Corrosive",
		:SECRETPOWERANIM => PBMoves::ACID,
		:NATUREMOVES => PBMoves::ACIDSPRAY,
		:MIMICRY => PBTypes::POISON,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::SMACKDOWN, PBMoves::MUDSLAP, PBMoves::MUDSHOT, PBMoves::MUDBOMB, 
						PBMoves::MUDDYWATER, PBMoves::WHIRLPOOL, PBMoves::THOUSANDARROWS],
		2.0 => [PBMoves::ACID, PBMoves::ACIDSPRAY, PBMoves::GRASSKNOT]},
		:MOVEACCURACYBOOST => {100 => [PBMoves::POISONPOWDER, PBMoves::SLEEPPOWDER, PBMoves::STUNSPORE, PBMoves::TOXIC]},
		:MOVEMESSAGES => {
		"The corrosion strengthened the attack!" => [PBMoves::SMACKDOWN, PBMoves::MUDSLAP, 
			PBMoves::MUDSHOT, PBMoves::MUDBOMB, PBMoves::MUDDYWATER, PBMoves::WHIRLPOOL, PBMoves::THOUSANDARROWS,
			PBMoves::ACID, PBMoves::ACIDSPRAY, PBMoves::GRASSKNOT]},
		:MOVETYPEMOD => {
		PBTypes::POISON => [PBMoves::SMACKDOWN, PBMoves::MUDSLAP, PBMoves::MUDSHOT, 
			PBMoves::MUDDYWATER, PBMoves::WHIRLPOOL, PBMoves::MUDBOMB, PBMoves::THOUSANDARROWS]},
		:TYPETYPEMOD => {PBTypes::POISON => [PBTypes::GRASS]},
		:FIELDCHANGE => {PBFields::GRASSYT => [PBMoves::SEEDFLARE]},
		:CHANGEMESSAGE => {"The polluted field was purified!" => [PBMoves::SEEDFLARE]},
		:STATUSMOVEBOOST => [PBMoves::ACIDARMOR, PBMoves::POISONPOWDER, PBMoves::SLEEPPOWDER, PBMoves::STUNSPORE, PBMoves::TOXIC],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::TELLURICSEED,
		:SEEDEFFECT => PBEffects::BanefulBunker,
		:SEEDEFFECTVAL => true,
		:SEEDEFFECTSTR => "The Telluric Seed shielded {1} against damage!",
		:SEEDANIM => PBMoves::BANEFULBUNKER,
		:SEEDSTATS => {}
		},
	# 11 Corrosive Mist Field
	PBFields::CORROSIVEMISTF => {
		:FIELDNAME => "Corrosive Mist Field",
		:INTROMESSAGE => "Corrosive mist settles on the field!",
		:FIELDGRAPHICS =>  "CorrosiveMist",
		:SECRETPOWERANIM => PBMoves::ACIDSPRAY,
		:NATUREMOVES => PBMoves::VENOSHOCK,
		:MIMICRY => PBTypes::POISON,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::BUBBLEBEAM, PBMoves::ACIDSPRAY, PBMoves::BUBBLE, PBMoves::SMOG, 
						PBMoves::CLEARSMOG, PBMoves::SPARKLINGARIA]},
		:MOVEACCURACYBOOST => {100 => [PBMoves::TOXIC]},
		:MOVEMESSAGES => {
		"The poison strengthened the attack!" => [PBMoves::BUBBLEBEAM, PBMoves::ACIDSPRAY, 
			PBMoves::BUBBLE, PBMoves::SMOG, PBMoves::CLEARSMOG, PBMoves::SPARKLINGARIA]},
		:MOVETYPEMOD => {
		PBTypes::POISON => [PBMoves::BUBBLE, PBMoves::BUBBLEBEAM,
			PBMoves::ENERGYBALL, PBMoves::SPARKLINGARIA]},
		:TYPEDAMAGEBOOST => {1.5 => [PBTypes::FIRE]},
		:TYPEMESSAGES => {"The toxic mist caught flame!" => [PBTypes::FIRE]},
		:FIELDCHANGE => {
		0 => PBFields::BLOWMOVES + PBFields::IGNITEMOVES + [PBMoves::SELFDESTRUCT, PBMoves::EXPLOSION] + [PBMoves::SEEDFLARE],
		PBFields::CORROSIVEF => [PBMoves::GRAVITY]},
		:DONTCHANGEBACKUP => [PBMoves::GRAVITY],
		:CHANGEMESSAGE => {
		#"The toxic mist combusted!" => PBFields::IGNITEMOVES + [PBMoves::SELFDESTRUCT, PBMoves::EXPLOSION],
		"The mist was blown away!" => PBFields::BLOWMOVES,
		"The polluted mist was purified!" => [PBMoves::SEEDFLARE],
		"The toxic mist collected on the ground!" => [PBMoves::GRAVITY]},
		:STATUSMOVEBOOST => [PBMoves::ACIDARMOR],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::ELEMENTALSEED,
		:SEEDEFFECT => 0,
		:SEEDEFFECTVAL => 0,
		:SEEDEFFECTSTR => "{1} was badly poisoned!",
		:SEEDANIM => 0,
		:SEEDSTATS => {PBStats::ATTACK => 1, PBStats::SPATK => 1}
		},
	# 12 Desert Field
	PBFields::DESERTF => {
		:FIELDNAME => "Desert Field",
		:INTROMESSAGE => "The field is rife with sand.",
		:FIELDGRAPHICS =>  "Desert",
		:SECRETPOWERANIM => PBMoves::SANDTOMB,
		:NATUREMOVES => PBMoves::SANDTOMB,
		:MIMICRY => PBTypes::GROUND,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::NEEDLEARM, PBMoves::PINMISSILE, PBMoves::DIG, PBMoves::SANDTOMB, 
						PBMoves::HEATWAVE, PBMoves::THOUSANDWAVES, PBMoves::BURNUP, PBMoves::SEARINGSUNRAZESMASH,
						PBMoves::SOLARBLADE, PBMoves::SOLARBEAM]},
		:MOVEMESSAGES => {
		"The desert strengthened the attack!" => [PBMoves::NEEDLEARM, PBMoves::PINMISSILE, 
			PBMoves::DIG, PBMoves::SANDTOMB, PBMoves::HEATWAVE, PBMoves::THOUSANDWAVES, 
			PBMoves::BURNUP, PBMoves::SEARINGSUNRAZESMASH, PBMoves::SOLARBLADE, PBMoves::SOLARBEAM]},
		:TYPEDAMAGEBOOST => {0.5 => [PBTypes::WATER,PBTypes::ELECTRIC]},
		:TYPEMESSAGES => {"The desert softened the attack..." => [PBTypes::WATER,PBTypes::ELECTRIC]},
		:TYPECONDITION => {
			PBTypes::WATER => "!attacker.isAirborne?" ,
			PBTypes::ELECTRIC => "!opponent.isAirborne?" },
		:STATUSMOVEBOOST => [PBMoves::SANDSTORM, PBMoves::SUNNYDAY, PBMoves::SANDATTACK, PBMoves::SHOREUP],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::TELLURICSEED,
		:SEEDEFFECT => PBEffects::MultiTurnAttack,
		:SEEDEFFECTVAL => PBMoves::SANDTOMB,
		:SEEDEFFECTSTR => "{1} was trapped by Sand Tomb!",
		:SEEDANIM => PBMoves::SANDTOMB,
		:SEEDSTATS => {PBStats::DEFENSE => 1, PBStats::SPDEF => 1, PBStats::SPEED => 1}
		},
	# 13 Icy Field
	PBFields::ICYF => {
		:FIELDNAME => "Icy Field",
		:INTROMESSAGE => "The field is covered in ice.",
		:FIELDGRAPHICS =>  "Icy",
		:SECRETPOWERANIM => PBMoves::ICESHARD,
		:NATUREMOVES => PBMoves::ICEBEAM,
		:MIMICRY => PBTypes::ICE,
		:MOVEDAMAGEBOOST => { 0.5 => [PBMoves::SCALD, PBMoves::STEAMERUPTION]},
		:MOVEMESSAGES => {"The cold softened the attack..." => [PBMoves::SCALD, PBMoves::STEAMERUPTION]},
		:TYPEDAMAGEBOOST => {
		1.5 => [PBTypes::ICE],
		0.5 => [PBTypes::FIRE]},
		:TYPEMESSAGES => {
		"The cold strengthened the attack!" => [PBTypes::ICE],
		"The cold softened the attack..." => [PBTypes::FIRE]},
		:TYPETYPEMOD => {PBTypes::ICE => [PBTypes::ROCK]},
		:FIELDCHANGE => {PBFields::WATERS => PBFields::IGNITEMOVES},
		:CHANGEMESSAGE => {"The ice melted away!" => PBFields::IGNITEMOVES},
		:STATUSMOVEBOOST => [PBMoves::HAIL],
		:STATUSMOVEBOOST => [PBMoves::ACIDARMOR],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::ELEMENTALSEED,
		:SEEDEFFECT => 0,
		:SEEDEFFECTVAL => 0,
		:SEEDEFFECTSTR => "{1} was hurt by icy Spikes!",
		:SEEDANIM => 0,
		:SEEDSTATS => {PBStats::SPEED => 2}
		},
	# 14 Rocky Field
	PBFields::ROCKYF => {
		:FIELDNAME => "Rocky Field",
		:INTROMESSAGE => "The field is littered with rocks.",
		:FIELDGRAPHICS =>  "Rocky",
		:SECRETPOWERANIM => PBMoves::ROCKTHROW,
		:NATUREMOVES => PBMoves::ROCKSMASH,
		:MIMICRY => PBTypes::ROCK,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::ROCKCLIMB, PBMoves::STRENGTH, PBMoves::MAGNITUDE, 
						PBMoves::EARTHQUAKE, PBMoves::BULLDOZE, PBMoves::ACCELEROCK],
		2.0 => [PBMoves::ROCKSMASH]},
		:MOVEMESSAGES => {
		"The rocks strengthened the attack!" => [PBMoves::ROCKCLIMB, PBMoves::STRENGTH, 
			PBMoves::MAGNITUDE, PBMoves::EARTHQUAKE, PBMoves::BULLDOZE, PBMoves::ACCELEROCK],
		"SMASH'D!" => [PBMoves::ROCKSMASH]},
		:MOVETYPEMOD => {
		PBTypes::ROCK => [PBMoves::ROCKCLIMB, PBMoves::EARTHQUAKE, PBMoves::MAGNITUDE, 
			PBMoves::STRENGTH, PBMoves::BULLDOZE]},
		:TYPEDAMAGEBOOST => {1.5 => [PBTypes::ROCK]},
		:TYPEMESSAGES => {"The field strengthened the attack!" => [PBTypes::ROCK]},
		:STATUSMOVEBOOST => [PBMoves::ROCKPOLISH],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::TELLURICSEED,
		:SEEDEFFECT => 0,
		:SEEDEFFECTVAL => 0,
		:SEEDEFFECTSTR => "{1} was hurt by Stealth Rocks!",
		:SEEDANIM => 0,
		:SEEDSTATS => {PBStats::DEFENSE => 1, PBStats::EVASION => 1}
		},
	# 15 Forest Field
	PBFields::FORESTF => {
		:FIELDNAME => "Forest Field",
		:INTROMESSAGE => "The field is abound with trees.",
		:FIELDGRAPHICS =>  "Forest",
		:SECRETPOWERANIM => PBMoves::WOODHAMMER,
		:NATUREMOVES => PBMoves::WOODHAMMER,
		:MIMICRY => PBTypes::GRASS,
		:MOVEDAMAGEBOOST => {
		0.5 => [PBMoves::SURF, PBMoves::MUDDYWATER],
		1.5 => [PBMoves::ATTACKORDER, PBMoves::ELECTROWEB, PBMoves::CUT]},
		:MOVEMESSAGES => {
		"The forest softened the attack..." => [PBMoves::SURF, PBMoves::MUDDYWATER],
		"They're coming out of the woodwork!" => [PBMoves::ATTACKORDER],
		"Gossamer and arbor strengthened the attack!" => [PBMoves::ELECTROWEB],
		"The target was cut down to size!" => [PBMoves::CUT]},
		:TYPEDAMAGEBOOST => {1.5 => [PBTypes::BUG,PBTypes::GRASS]},
		:TYPEMESSAGES => {
		"The field strengthened the attack!" => [PBTypes::BUG],
		"The forestry strengthened the attack!" => [PBTypes::GRASS]},
		:TYPECONDITION => {PBTypes::BUG => "self.pbIsSpecial?(type)" },
		:FIELDCHANGE => {PBFields::BURNINGF => PBFields::IGNITEMOVES},
		:DONTCHANGEBACKUP => PBFields::IGNITEMOVES,
		:CHANGEMESSAGE => {"The forest caught fire!" => PBFields::IGNITEMOVES},
		:CHANGECONDITION => {PBFields::BURNINGF => "ignitecheck"},
		:STATUSMOVEBOOST => [PBMoves::STICKYWEB, PBMoves::DEFENDORDER, PBMoves::GROWTH,
		 	PBMoves::STRENGTHSAP, PBMoves::HEALORDER, PBMoves::NATURESMADNESS, PBMoves::FORESTSCURSE],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::TELLURICSEED,
		:SEEDEFFECT => PBEffects::SpikyShield,
		:SEEDEFFECTVAL => true,
		:SEEDEFFECTSTR => "The Telluric Seed shielded {1} against damage!",
		:SEEDANIM => PBMoves::SPIKYSHIELD,
		:SEEDSTATS => {}
		},
	# 16 Superheated Field
	PBFields::SUPERHEATEDF => {
		:FIELDNAME => "Super-Heated Field",
		:INTROMESSAGE => "The field is super-heated!",
		:FIELDGRAPHICS =>  "Superheated",
		:SECRETPOWERANIM => PBMoves::FLAMEBURST,
		:NATUREMOVES => PBMoves::HEATWAVE,
		:MIMICRY => PBTypes::FIRE,
		:MOVEDAMAGEBOOST => {
		0.625 => [PBMoves::SURF, PBMoves::MUDDYWATER, PBMoves::WATERPLEDGE, 
							PBMoves::WATERSPOUT, PBMoves::SPARKLINGARIA, PBMoves::HYDROVORTEX, PBMoves::OCEANICOPERETTA],
		1.667 => [PBMoves::SCALD, PBMoves::STEAMERUPTION]},
		:MOVEMESSAGES => {
		#"cass couldn't find this message. make ame fix it." => [PBMoves::SURF, PBMoves::MUDDYWATER, PBMoves::WATERPLEDGE, 
		#		PBMoves::WATERSPOUT, PBMoves::SPARKLINGARIA, PBMoves::HYDROVORTEX, PBMoves::OCEANICOPERETTA],
		#This message is handled elsewhere, "Steam shot up from the field!"
		"The field super-heated the attack!" => [PBMoves::SCALD, PBMoves::STEAMERUPTION]},
		:TYPEDAMAGEBOOST => {
		0.5 => [PBTypes::ICE],
		0.9 => [PBTypes::WATER],
		1.1 => [PBTypes::FIRE]},
		:TYPEMESSAGES => {
		"The extreme heat softened the attack..." => [PBTypes::ICE,PBTypes::WATER],
		"The attack was super-heated!" => [PBTypes::FIRE]},
		:FIELDCHANGE => {
		PBFields::BURNINGF => PBFields::IGNITEMOVES + [PBMoves::SELFDESTRUCT, PBMoves::EXPLOSION],
		0 => [PBMoves::BLIZZARD, PBMoves::GLACIATE, PBMoves::SUBZEROSLAMMER]},
		:DONTCHANGEBACKUP => PBFields::IGNITEMOVES + [PBMoves::SELFDESTRUCT, PBMoves::EXPLOSION],
		:CHANGEMESSAGE => {
		"The field combusted!" => PBFields::IGNITEMOVES + [PBMoves::SELFDESTRUCT, PBMoves::EXPLOSION],
		"The field cooled off!"=> [PBMoves::BLIZZARD, PBMoves::GLACIATE, PBMoves::SUBZEROSLAMMER]},
		:CHANGECONDITION => {PBFields::BURNINGF => "ignitecheck"},
		:STATUSMOVEBOOST => [],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::TELLURICSEED,
		:SEEDEFFECT => PBEffects::ShellTrap,
		:SEEDEFFECTVAL => true,
		:SEEDEFFECTSTR => "{1} primed a trap!",
		:SEEDANIM => PBMoves::SHELLTRAP,
		:SEEDSTATS => {PBStats::DEFENSE => 1}
		},
	# 17 Factory Field
	PBFields::FACTORYF => {
		:FIELDNAME => "Factory Field",
		:INTROMESSAGE => "Machines whir in the background.",
		:FIELDGRAPHICS =>  "Factory",
		:SECRETPOWERANIM => PBMoves::MAGNETBOMB,
		:NATUREMOVES => PBMoves::GEARGRIND,
		:MIMICRY => PBTypes::STEEL,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::STEAMROLLER, PBMoves::TECHNOBLAST],
		2.0 => [PBMoves::FLASHCANNON, PBMoves::GYROBALL, PBMoves::MAGNETBOMB, PBMoves::GEARGRIND]},
		:MOVEMESSAGES => {
		"ATTACK SEQUENCE UPDATE." => [PBMoves::STEAMROLLER, PBMoves::TECHNOBLAST],
		"ATTACK SEQUENCE INITIATE." => [PBMoves::FLASHCANNON, PBMoves::GYROBALL, 
			PBMoves::MAGNETBOMB, PBMoves::GEARGRIND]},
		:TYPEDAMAGEBOOST => {1.5 => [PBTypes::ELECTRIC]},
		:TYPEMESSAGES => {"The attack took energy from the field!" => [PBTypes::ELECTRIC]},
		:FIELDCHANGE => {
		PBFields::SHORTCIRCUITF => PBFields::QUAKEMOVES + [PBMoves::SELFDESTRUCT, PBMoves::EXPLOSION, PBMoves::LIGHTTHATBURNSTHESKY]},
		:CHANGEMESSAGE => {
		"The field was broken!" => PBFields::QUAKEMOVES + [PBMoves::SELFDESTRUCT, PBMoves::EXPLOSION],
		"All the light was consumed!" => [PBMoves::LIGHTTHATBURNSTHESKY]},
		:STATUSMOVEBOOST => [PBMoves::AUTOTOMIZE, PBMoves::IRONDEFENSE, PBMoves::METALSOUND, PBMoves::SHIFTGEAR, PBMoves::MAGNETRISE, PBMoves::GEARUP],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::SYNTHETICSEED,
		:SEEDEFFECT => PBEffects::LaserFocus,
		:SEEDEFFECTVAL => 1,
		:SEEDEFFECTSTR => "{1} is focused!",
		:SEEDANIM => PBMoves::LASERFOCUS,
		:SEEDSTATS => {PBStats::SPATK => 1}
		},
	# 18 Short-Circuit Field
	PBFields::SHORTCIRCUITF => {
		:FIELDNAME => "Short-Circuit Field",
		:INTROMESSAGE => "Bzzt!",
		:FIELDGRAPHICS =>  "Shortcircuit",
		:SECRETPOWERANIM => PBMoves::ELECTROBALL,
		:NATUREMOVES => PBMoves::DISCHARGE,
		:MIMICRY => PBTypes::ELECTRIC,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::DAZZLINGGLEAM, PBMoves::SURF, PBMoves::MUDDYWATER, PBMoves::MAGNETBOMB,
						PBMoves::GYROBALL, PBMoves::FLASHCANNON, PBMoves::GEARGRIND, PBMoves::HYDROVORTEX],
		1.3 => [PBMoves::DARKPULSE, PBMoves::NIGHTDAZE, PBMoves::NIGHTSLASH, 
						PBMoves::SHADOWBALL, PBMoves::SHADOWPUNCH, PBMoves::SHADOWCLAW,
						PBMoves::SHADOWSNEAK, PBMoves::SHADOWFORCE, PBMoves::SHADOWBONE],
		0.5 => [PBMoves::LIGHTTHATBURNSTHESKY]},
		:MOVEACCURACYBOOST => {80 => [PBMoves::ZAPCANNON]},
		:MOVEMESSAGES => {
		"Blinding!" => [PBMoves::DAZZLINGGLEAM], 
		"The attack picked up electricity!" => [PBMoves::SURF, PBMoves::MUDDYWATER, 
			PBMoves::MAGNETBOMB, PBMoves::GYROBALL, PBMoves::FLASHCANNON, PBMoves::GEARGRIND, PBMoves::HYDROVORTEX],
		"The darkness strengthened the attack!" => [PBMoves::DARKPULSE, PBMoves::NIGHTDAZE, 
			PBMoves::NIGHTSLASH, PBMoves::SHADOWBALL, PBMoves::SHADOWPUNCH, PBMoves::SHADOWCLAW, 
			PBMoves::SHADOWSNEAK, PBMoves::SHADOWFORCE, PBMoves::SHADOWBONE],
		"{1} couldn't consume much light..." => [PBMoves::LIGHTTHATBURNSTHESKY]},
		:MOVETYPEMOD => {
		PBTypes::ELECTRIC => [PBMoves::SURF, PBMoves::MUDDYWATER, PBMoves::MAGNETBOMB, 
			PBMoves::GYROBALL, PBMoves::FLASHCANNON, PBMoves::GEARGRIND]},
		:FIELDCHANGE => {PBFields::FACTORYF => [PBMoves::PARABOLICCHARGE, PBMoves::WILDCHARGE,
											PBMoves::CHARGEBEAM, PBMoves::IONDELUGE, PBMoves::GIGAVOLTHAVOC]},
		:CHANGEMESSAGE => {"SYSTEM ONLINE." => [PBMoves::PARABOLICCHARGE, PBMoves::WILDCHARGE, 
												PBMoves::CHARGEBEAM, PBMoves::IONDELUGE, PBMoves::GIGAVOLTHAVOC]},
		:STATUSMOVEBOOST => [PBMoves::FLASH, PBMoves::METALSOUND, PBMoves::MAGNETRISE],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::SYNTHETICSEED,
		:SEEDEFFECT => PBEffects::MagnetRise,
		:SEEDEFFECTVAL => 5,
		:SEEDEFFECTSTR => "{1} levitated with electromagnetism!",
		:SEEDANIM => PBMoves::MAGNETRISE,
		:SEEDSTATS => {PBStats::SPDEF => 1}
		},
	# 19 Wasteland
	PBFields::WASTELAND => {
		:FIELDNAME => "Wasteland",
		:INTROMESSAGE => "The waste is watching...",
		:FIELDGRAPHICS =>  "Wasteland",
		:SECRETPOWERANIM => PBMoves::GUNKSHOT,
		:NATUREMOVES => PBMoves::GUNKSHOT,
		:MIMICRY => PBTypes::POISON,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::VINEWHIP, PBMoves::POWERWHIP, PBMoves::MUDSLAP, 
						PBMoves::MUDBOMB, PBMoves::MUDSHOT],
		0.25 => [PBMoves::EARTHQUAKE, PBMoves::MAGNITUDE, PBMoves::BULLDOZE],
		2.0 => [PBMoves::SPITUP],
		1.2 => [PBMoves::OCTAZOOKA, PBMoves::SLUDGE, PBMoves::GUNKSHOT, 
						PBMoves::SLUDGEWAVE, PBMoves::SLUDGEBOMB]},
		:MOVEMESSAGES => {
		"The waste did it for the vine!" => [PBMoves::VINEWHIP, PBMoves::POWERWHIP], 
		"The waste was added to the attack!" => [PBMoves::MUDSLAP, PBMoves::MUDBOMB, PBMoves::MUDSHOT],
		"Wibble-wibble wobble-wobb..." => [PBMoves::EARTHQUAKE, PBMoves::MAGNITUDE, PBMoves::BULLDOZE],
		"BLEAAARGGGGH!" => [PBMoves::SPITUP],
		"The waste joined the attack!" => [PBMoves::OCTAZOOKA, PBMoves::SLUDGE, PBMoves::GUNKSHOT, 
			PBMoves::SLUDGEWAVE, PBMoves::SLUDGEBOMB]},
		:MOVETYPEMOD => {
		PBTypes::POISON => [PBMoves::MUDBOMB, PBMoves::MUDSLAP, PBMoves::MUDSHOT]},
		:STATUSMOVEBOOST => [PBMoves::SWALLOW],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::TELLURICSEED,
		:SEEDEFFECT => 0,
		:SEEDEFFECTVAL => 0,
		:SEEDEFFECTSTR => "",
		:SEEDANIM => 0,
		:SEEDSTATS => {PBStats::ATTACK => 1, PBStats::SPATK => 1}
		},
	# 20 Ashen Beach
	PBFields::ASHENB => {
		:FIELDNAME => "Ashen Beach",
		:INTROMESSAGE => "Ash and sand line the field.",
		:FIELDGRAPHICS =>  "AshenBeach",
		:SECRETPOWERANIM => PBMoves::MUDSHOT,
		:NATUREMOVES => PBMoves::MEDITATE,
		:MIMICRY => PBTypes::GROUND,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::HIDDENPOWER, PBMoves::STRENGTH, PBMoves::LANDSWRATH, 
						PBMoves::THOUSANDWAVES, PBMoves::SURF, PBMoves::MUDDYWATER, PBMoves::CLANGOROUSSOULBLAZE],
		2.0 => [PBMoves::MUDSLAP, PBMoves::MUDSHOT, PBMoves::MUDBOMB , PBMoves::SANDTOMB],
		1.3 => [PBMoves::STOREDPOWER, PBMoves::ZENHEADBUTT, 
						PBMoves::FOCUSBLAST, PBMoves::AURASPHERE],
		1.2 => [PBMoves::PSYCHIC]},
		:MOVEACCURACYBOOST => {90 => [PBMoves::FOCUSBLAST]},
		:MOVEMESSAGES => {
		"...And with pure focus!" => [PBMoves::HIDDENPOWER, PBMoves::STRENGTH, PBMoves::CLANGOROUSSOULBLAZE], 
		"The sand strengthened the atttack!" => [PBMoves::LANDSWRATH, PBMoves::THOUSANDWAVES], 
		"Surf's up!" => [PBMoves::SURF, PBMoves::MUDDYWATER],
		"Ash mixed into the attack!" => [PBMoves::MUDSLAP, PBMoves::MUDSHOT, PBMoves::MUDBOMB , PBMoves::SANDTOMB],
		"...And with full focus...!" => [PBMoves::STOREDPOWER, PBMoves::ZENHEADBUTT, 
			PBMoves::FOCUSBLAST, PBMoves::AURASPHERE],
		"...And with focus...!" => [PBMoves::PSYCHIC]},
		:MOVETYPEMOD => {PBTypes::PSYCHIC => [PBMoves::STRENGTH]},
		:STATUSMOVEBOOST => [PBMoves::CALMMIND, PBMoves::KINESIS, PBMoves::MEDITATE, PBMoves::SANDATTACK,
			PBMoves::SANDSTORM, PBMoves::FOCUSENERGY, PBMoves::SHOREUP],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::TELLURICSEED,
		:SEEDEFFECT => PBEffects::FocusEnergy,
		:SEEDEFFECTVAL => 3,
		:SEEDEFFECTSTR => "{1}'s Telluric Seed is getting it pumped!",
		:SEEDANIM => PBMoves::FOCUSENERGY,
		:SEEDSTATS => {}
		},
	# 21 Water Surface
	PBFields::WATERS => {
		:FIELDNAME => "Water Surface",
		:INTROMESSAGE => "The water's surface is calm.",
		:FIELDGRAPHICS =>  "WaterSurface",
		:SECRETPOWERANIM => PBMoves::AQUAJET,
		:NATUREMOVES => PBMoves::WHIRLPOOL,
		:MIMICRY => PBTypes::WATER,
		:MOVEDAMAGEBOOST => {
			1.5 => [PBMoves::SURF, PBMoves::MUDDYWATER, PBMoves::WHIRLPOOL, PBMoves::DIVE, PBMoves::HYDROVORTEX]},
		:MOVEMESSAGES => {
			"The attack rode the current!" => [PBMoves::SURF, PBMoves::MUDDYWATER, 
				PBMoves::WHIRLPOOL, PBMoves::DIVE, PBMoves::HYDROVORTEX]},
		:TYPEDAMAGEBOOST => {
			1.5 => [PBTypes::WATER,PBTypes::ELECTRIC],
			0.5 => [PBTypes::FIRE]},
		:TYPEMESSAGES => {
			"The water conducted the attack!" => [PBTypes::ELECTRIC],
			"The water strengthened the attack!" => [PBTypes::WATER],
			"The water deluged the attack..." => [PBTypes::FIRE]},
		:TYPECONDITION => {
			PBTypes::FIRE => "!opponent.isAirborne?" ,
			PBTypes::ELECTRIC => "!opponent.isAirborne?" },
		:FIELDCHANGE => {
			PBFields::UNDERWATER => [PBMoves::GRAVITY,PBMoves::DIVE],
			PBFields::ICYF => [PBMoves::BLIZZARD, PBMoves::GLACIATE, PBMoves::SUBZEROSLAMMER]},
		:DONTCHANGEBACKUP => [PBMoves::BLIZZARD, PBMoves::GLACIATE, PBMoves::SUBZEROSLAMMER],
		:CHANGEMESSAGE => {
			"The battle sank into the depths!" => [PBMoves::GRAVITY],
			"The battle was pulled underwater!" => [PBMoves::DIVE],
			"The water froze over!" => [PBMoves::BLIZZARD, PBMoves::GLACIATE, PBMoves::SUBZEROSLAMMER]},
		:STATUSMOVEBOOST => [PBMoves::SPLASH, PBMoves::AQUARING],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::ELEMENTALSEED,
		:SEEDEFFECT => PBEffects::AquaRing,
		:SEEDEFFECTVAL => true,
		:SEEDEFFECTSTR => "{1} surrounded itself with a veil of water!",
		:SEEDANIM => PBMoves::AQUARING,
		:SEEDSTATS => {PBStats::SPDEF => 1}
		},
	# 22 Underwater
	PBFields::UNDERWATER => {
		:FIELDNAME => "Underwater",
		:INTROMESSAGE => "Blub blub...",
		:FIELDGRAPHICS =>  "Underwater",
		:SECRETPOWERANIM => PBMoves::AQUATAIL,
		:NATUREMOVES => PBMoves::WATERPULSE,
		:MIMICRY => PBTypes::WATER,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::WATERPULSE],
		2.0 => [PBMoves::ANCHORSHOT]},
		:MOVEMESSAGES => {
			"Jet-streamed!" => [PBMoves::WATERPULSE],
			"From the depths!" => [PBMoves::ANCHORSHOT]},
		:TYPETYPEMOD => {PBTypes::WATER => [PBTypes::GROUND]},
		:TYPEDAMAGEBOOST => {
		1.5 => [PBTypes::WATER],
		2.0 => [PBTypes::ELECTRIC]},
		:TYPEMESSAGES => {
		"The water strengthened the attack!" => [PBTypes::WATER],
		"The water super-conducted the attack!" => [PBTypes::ELECTRIC]},
		:FIELDCHANGE => {PBFields::WATERS => [PBMoves::DIVE, PBMoves::SKYDROP, PBMoves::FLY, PBMoves::BOUNCE]},
		:CHANGEMESSAGE => {"The battle resurfaced!" => [PBMoves::DIVE, 
			PBMoves::SKYDROP, PBMoves::FLY, PBMoves::BOUNCE]},
		:STATUSMOVEBOOST => [PBMoves::AQUARING],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::ELEMENTALSEED,
		:SEEDEFFECT => 0,
		:SEEDEFFECTVAL => 0,
		:SEEDEFFECTSTR => "{1} transformed into the Water type!",
		:SEEDANIM => PBMoves::SOAK,
		:SEEDSTATS => {PBStats::SPEED => 1}
		},
	# 23 Cave
	PBFields::CAVE => {
		:FIELDNAME => "Cave",
		:INTROMESSAGE => "The cave echoes dully...",
		:FIELDGRAPHICS =>  "Cave",
		:SECRETPOWERANIM => PBMoves::ROCKWRECKER,
		:NATUREMOVES => PBMoves::ROCKTOMB,
		:MIMICRY => PBTypes::ROCK,
		:MOVEDAMAGEBOOST => {1.5 => [PBMoves::ROCKTOMB]},
		:MOVEMESSAGES => {"...Piled on!" => [PBMoves::ROCKTOMB]},
		:TYPEDAMAGEBOOST => {
			1.5 => [PBTypes::ROCK],
			0.5 => [PBTypes::FLYING]},
		:TYPEMESSAGES => {
		"The cave choked out the air!" => [PBTypes::FLYING],
		"The cavern strengthened the attack!" => [PBTypes::ROCK]},
		:TYPECONDITION => {PBTypes::FLYING => "!self.isContactMove?" },
		:FIELDCHANGE => {
			PBFields::CRYSTALC => [PBMoves::POWERGEM, PBMoves::DIAMONDSTORM],
			PBFields::CAVE => PBFields::QUAKEMOVES + [PBMoves::CONTINENTALCRUSH]},
		:DONTCHANGEBACKUP => [PBMoves::POWERGEM, PBMoves::DIAMONDSTORM],
		:CHANGEMESSAGE => {"The cave was littered with crystals!" => [PBMoves::POWERGEM, PBMoves::DIAMONDSTORM]},
		:CHANGECONDITION => {},
		:STATUSMOVEBOOST => [PBMoves::STEALTHROCK],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::TELLURICSEED,
		:SEEDEFFECT => 0,
		:SEEDEFFECTVAL => 0,
		:SEEDEFFECTSTR => "{1} was hurt by Stealth Rocks!",
		:SEEDANIM => 0,
		:SEEDSTATS => {PBStats::DEFENSE => 2}
		},
	# 24 Glitch Field
	PBFields::GLITCHF => {
		:FIELDNAME => "Glitch Field",
		:INTROMESSAGE => "1n!taliz3 .b//////attl3",
		:FIELDGRAPHICS =>  "Glitch",
		:SECRETPOWERANIM => PBMoves::TECHNOBLAST,
		:NATUREMOVES => PBMoves::METRONOME,
		:MIMICRY => PBTypes::QMARKS,
		:MOVEDAMAGEBOOST => {},
		:MOVEACCURACYBOOST => {90 => [PBMoves::BLIZZARD]},
		:MOVEMESSAGES => {},
		:TYPEDAMAGEBOOST => {1.2 => [PBTypes::PSYCHIC]},
		:TYPEMESSAGES => {".0P pl$ nerf!-//" => [PBTypes::PSYCHIC]},
		:STATUSMOVEBOOST => [],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::SYNTHETICSEED,
		:SEEDEFFECT => 0,
		:SEEDEFFECTVAL => 0,
		:SEEDEFFECTSTR => "{1}.TYPE = (PBTypes::QMARKS)",
		:SEEDANIM => PBMoves::AMNESIA,
		:SEEDSTATS => {PBStats::DEFENSE => 1}
		},
	# 25 Crystal Cavern
	PBFields::CRYSTALC => {
		:FIELDNAME => "Crystal Cavern",
		:INTROMESSAGE => "The cave is littered with crystals.",
		:FIELDGRAPHICS =>  "CrystalCavern",
		:SECRETPOWERANIM => PBMoves::POWERGEM,
		:NATUREMOVES => PBMoves::POWERGEM,
		:MIMICRY => PBTypes::QMARKS, #RNG
		:MOVEDAMAGEBOOST => {
		1.3 => [PBMoves::AURORABEAM, PBMoves::SIGNALBEAM, PBMoves::FLASHCANNON, 
						PBMoves::LUSTERPURGE, PBMoves::DAZZLINGGLEAM, PBMoves::MIRRORSHOT, 
						PBMoves::TECHNOBLAST, PBMoves::DOOMDUMMY, PBMoves::MOONGEISTBEAM, 
						PBMoves::PHOTONGEYSER, PBMoves::MENACINGMOONRAZEMAELSTROM],
		1.5 => [PBMoves::POWERGEM, PBMoves::DIAMONDSTORM, PBMoves::ANCIENTPOWER, 
						PBMoves::JUDGMENT, PBMoves::ROCKSMASH, PBMoves::ROCKTOMB, PBMoves::STRENGTH, 
						PBMoves::ROCKCLIMB, PBMoves::MULTIATTACK]},
		:MOVEMESSAGES => {
		"The crystals' light strengthened the attack!" => [PBMoves::AURORABEAM, 
			PBMoves::SIGNALBEAM, PBMoves::FLASHCANNON, PBMoves::LUSTERPURGE, 
			PBMoves::DAZZLINGGLEAM, PBMoves::MIRRORSHOT, PBMoves::TECHNOBLAST, 
			PBMoves::DOOMDUMMY, PBMoves::MOONGEISTBEAM, PBMoves::PHOTONGEYSER,
			PBMoves::MENACINGMOONRAZEMAELSTROM],
		"The crystals strengthened the attack!" => [PBMoves::POWERGEM, PBMoves::DIAMONDSTORM, 
			PBMoves::ANCIENTPOWER, PBMoves::JUDGMENT, PBMoves::ROCKSMASH, PBMoves::ROCKTOMB, 
			PBMoves::STRENGTH, PBMoves::ROCKCLIMB, PBMoves::MULTIATTACK]},
		:TYPEDAMAGEBOOST => {1.5 => [PBTypes::ROCK,PBTypes::DRAGON]},
		:TYPEMESSAGES => {
			"The crystals charged the attack!" => [PBTypes::ROCK],
			"The crystal energy strengthened the attack!" => [PBTypes::DRAGON]},
		:FIELDCHANGE => {
			PBFields::CAVE => PBFields::QUAKEMOVES,
			PBFields::DARKCRYSTALC => [PBMoves::DARKPULSE, PBMoves::DARKVOID, PBMoves::NIGHTDAZE, PBMoves::LIGHTTHATBURNSTHESKY]},
		:DONTCHANGEBACKUP => PBFields::QUAKEMOVES + [PBMoves::DARKPULSE, PBMoves::DARKVOID, PBMoves::NIGHTDAZE],
		:CHANGEMESSAGE => {
			"The crystals were broken up!" => PBFields::QUAKEMOVES,
			"The crystals' light was warped by the darkness!" => [PBMoves::DARKPULSE, 
				PBMoves::DARKVOID, PBMoves::NIGHTDAZE],
			"The crystals' light was consumed!" => [PBMoves::LIGHTTHATBURNSTHESKY]},
		:STATUSMOVEBOOST => [PBMoves::ROCKPOLISH, PBMoves::STEALTHROCK],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::MAGICALSEED,
		:SEEDEFFECT => PBEffects::MagicCoat,
		:SEEDEFFECTVAL => true,
		:SEEDEFFECTSTR => "{1} shrouded itself with Magic Coat!",
		:SEEDANIM => PBMoves::MAGICCOAT,
		:SEEDSTATS => {PBStats::SPATK => 1}
		},
	# 26 Murkwater Surface
	PBFields::MURKWATERS => {
		:FIELDNAME => "Murkwater Surface",
		:INTROMESSAGE => "The water is tainted...",
		:FIELDGRAPHICS =>  "MurkwaterSurface",
		:SECRETPOWERANIM => PBMoves::SLUDGEBOMB,
		:NATUREMOVES => PBMoves::SLUDGEWAVE,
		:MIMICRY => PBTypes::POISON,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::MUDBOMB, PBMoves::MUDSLAP, PBMoves::MUDSHOT, PBMoves::SMACKDOWN, 
						PBMoves::ACID, PBMoves::ACIDSPRAY, PBMoves::BRINE, PBMoves::THOUSANDWAVES]},
		:MOVEMESSAGES => {
		"The toxic water strengthened the attack!" => [PBMoves::MUDBOMB, PBMoves::MUDSLAP, 
			PBMoves::MUDSHOT, PBMoves::SMACKDOWN, PBMoves::ACID, PBMoves::ACIDSPRAY, PBMoves::THOUSANDWAVES],
		"Stinging!" => [PBMoves::BRINE]},
		:MOVETYPEMOD => {
		PBTypes::POISON => [PBMoves::MUDBOMB, PBMoves::MUDSLAP, PBMoves::MUDSHOT, 
												PBMoves::SMACKDOWN, PBMoves::THOUSANDWAVES],
		PBTypes::WATER => [PBMoves::SLUDGEWAVE]},
		:TYPETYPEMOD => {PBTypes::POISON => [PBTypes::WATER]},
		:TYPEDAMAGEBOOST => {
			1.5 => [PBTypes::WATER,PBTypes::POISON],
			1.3 => [PBTypes::ELECTRIC],
		},
		:TYPEMESSAGES => {
		"The toxic water strengthened the attack!" => [PBTypes::WATER,PBTypes::POISON],
		"The toxic water conducted the attack!" => [PBTypes::ELECTRIC]},
		:TYPECONDITION => {
			PBTypes::ELECTRIC => "!opponent.isAirborne?",
		},
		:FIELDCHANGE => {
		PBFields::WATERS => [PBMoves::WHIRLPOOL],
		PBFields::ICYF => [PBMoves::BLIZZARD, PBMoves::GLACIATE,PBMoves::SUBZEROSLAMMER]},
		:DONTCHANGEBACKUP => [PBMoves::WHIRLPOOL,PBMoves::BLIZZARD, PBMoves::GLACIATE,PBMoves::SUBZEROSLAMMER],
		:CHANGEMESSAGE => {
		"The maelstrom flushed out the poison!" => [PBMoves::WHIRLPOOL],
		"The toxic water froze over!" => [PBMoves::BLIZZARD, PBMoves::GLACIATE,PBMoves::SUBZEROSLAMMER]},
		:STATUSMOVEBOOST => [PBMoves::ACIDARMOR],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::ELEMENTALSEED,
		:SEEDEFFECT => PBEffects::AquaRing,
		:SEEDEFFECTVAL => true,
		:SEEDEFFECTSTR => "{1} surrounded itself with a veil of water!",
		:SEEDANIM => PBMoves::AQUARING,
		:SEEDSTATS => {PBStats::SPEED => 1}
		},
	# 27 Mountain
	PBFields::MOUNTAIN => {
		:FIELDNAME => "Mountain",
		:INTROMESSAGE => ["Adieu to disappointment and spleen,","What are men to rocks and mountains?"], #oh good, i hate spleen
		:FIELDGRAPHICS =>  "Mountain",
		:SECRETPOWERANIM => PBMoves::ROCKBLAST,
		:NATUREMOVES => PBMoves::ROCKSLIDE,
		:MIMICRY => PBTypes::ROCK,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::VITALTHROW, PBMoves::CIRCLETHROW, PBMoves::STORMTHROW, 
						PBMoves::OMINOUSWIND, PBMoves::ICYWIND, PBMoves::SILVERWIND, PBMoves::TWISTER, 
						PBMoves::RAZORWIND, PBMoves::FAIRYWIND, PBMoves::THUNDER, PBMoves::ERUPTION, 
						PBMoves::AVALANCHE, PBMoves::HYPERVOICE]},
		:MOVEMESSAGES => {
		"{1} was thrown partway down the mountain!" => [PBMoves::VITALTHROW, 
			PBMoves::CIRCLETHROW, PBMoves::STORMTHROW],
		"The wind strengthened the attack!" => [PBMoves::OMINOUSWIND, PBMoves::ICYWIND, 
			PBMoves::SILVERWIND, PBMoves::TWISTER, PBMoves::RAZORWIND, PBMoves::FAIRYWIND], 
		"The mountain strengthened the attack!" => [PBMoves::THUNDER, 
			PBMoves::ERUPTION, PBMoves::AVALANCHE],
		"Yodelayheehoo~" => [PBMoves::HYPERVOICE]},
		:TYPEDAMAGEBOOST => {1.5 => [PBTypes::ROCK,PBTypes::FLYING]},
		:TYPEMESSAGES => {
		"The mountain strengthened the attack!" => [PBTypes::ROCK],
		"The open air strengthened the attack!" => [PBTypes::FLYING]},
		:FIELDCHANGE => {PBFields::SNOWYM => [PBMoves::BLIZZARD, PBMoves::GLACIATE,PBMoves::SUBZEROSLAMMER]},
		:DONTCHANGEBACKUP => [PBMoves::BLIZZARD, PBMoves::GLACIATE,PBMoves::SUBZEROSLAMMER],
		:CHANGEMESSAGE => {"The mountain was covered in snow!" => [PBMoves::BLIZZARD, PBMoves::GLACIATE,PBMoves::SUBZEROSLAMMER]},
		:STATUSMOVEBOOST => [PBMoves::TAILWIND, PBMoves::SUNNYDAY],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::TELLURICSEED,
		:SEEDEFFECT => 0,
		:SEEDEFFECTVAL => 0,
		:SEEDEFFECTSTR => "",
		:SEEDANIM => 0,
		:SEEDSTATS => {PBStats::ATTACK => 2, PBStats::ACCURACY => -1}
		},
	# 28 Snowy Mountain
	PBFields::SNOWYM => {
		:FIELDNAME => "Snowy Mountain",
		:INTROMESSAGE => "The snow glows white on the mountain...",
		:FIELDGRAPHICS =>  "SnowyMountain",
		:SECRETPOWERANIM => PBMoves::ICEBALL,
		:NATUREMOVES => PBMoves::AVALANCHE,
		:MIMICRY => PBTypes::ICE,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::VITALTHROW, PBMoves::CIRCLETHROW, PBMoves::STORMTHROW, 
						PBMoves::OMINOUSWIND, PBMoves::SILVERWIND, PBMoves::TWISTER, PBMoves::RAZORWIND, 
						PBMoves::FAIRYWIND, PBMoves::AVALANCHE, PBMoves::POWDERSNOW, PBMoves::HYPERVOICE,
						PBMoves::GLACIATE],
		0.5 => [PBMoves::SCALD, PBMoves::STEAMERUPTION],
		2.0 => [PBMoves::ICYWIND]},
		:MOVEMESSAGES => {
		"{1} was thrown partway down the mountain!" => [PBMoves::VITALTHROW, 
			PBMoves::CIRCLETHROW, PBMoves::STORMTHROW],
		"The wind strengthened the attack!" => [PBMoves::OMINOUSWIND, PBMoves::SILVERWIND, 
			PBMoves::TWISTER, PBMoves::RAZORWIND, PBMoves::FAIRYWIND], 
		"The snow strengthened the attack!" => [PBMoves::AVALANCHE, PBMoves::POWDERSNOW],
		"The cold softened the attack..." => [PBMoves::SCALD, PBMoves::STEAMERUPTION],
		"The frigid wind strengthened the attack!" => [PBMoves::ICYWIND],
		"Yodelayheehoo~" => [PBMoves::HYPERVOICE]},
		:TYPETYPEMOD => {PBTypes::ICE => [PBTypes::ROCK]},
		:TYPEDAMAGEBOOST => {
		1.5 => [PBTypes::ROCK,PBTypes::ICE,PBTypes::FLYING],
		0.5 => [PBTypes::FIRE]},
		:TYPEMESSAGES => {
		"The snowy mountain strengthened the attack!" => [PBTypes::ROCK,PBTypes::ICE],
		"The open air strengthened the attack!" => [PBTypes::FLYING],
		"The cold softened the attack!" => [PBTypes::FIRE]},
		:FIELDCHANGE => {PBFields::MOUNTAIN => PBFields::IGNITEMOVES},
		:CHANGEMESSAGE => {"The snow melted away!" => PBFields::IGNITEMOVES},
		:STATUSMOVEBOOST => [PBMoves::TAILWIND, PBMoves::SUNNYDAY, PBMoves::HAIL],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::TELLURICSEED,
		:SEEDEFFECT => 0,
		:SEEDEFFECTVAL => 0,
		:SEEDEFFECTSTR => "",
		:SEEDANIM => 0,
		:SEEDSTATS => {PBStats::SPATK => 2, PBStats::ACCURACY => -1}
		},
	# 29 Holy Field
	PBFields::HOLYF => {
		:FIELDNAME => "Holy Field",
		:INTROMESSAGE => "Benedictus Sanctus Spiritus...",
		:FIELDGRAPHICS =>  "Holy",
		:SECRETPOWERANIM => PBMoves::DAZZLINGGLEAM,
		:NATUREMOVES => PBMoves::JUDGMENT,
		:MIMICRY => PBTypes::NORMAL,
		:MOVEDAMAGEBOOST => {
		1.3 => [PBMoves::PSYSTRIKE, PBMoves::AEROBLAST, 
				PBMoves::ORIGINPULSE, PBMoves::DOOMDUMMY, PBMoves::MISTBALL, 
				PBMoves::CRUSHGRIP, PBMoves::LUSTERPURGE, PBMoves::SECRETSWORD, 
				PBMoves::PSYCHOBOOST, PBMoves::RELICSONG, PBMoves::SPACIALREND, 
				PBMoves::HYPERSPACEHOLE, PBMoves::ROAROFTIME, PBMoves::LANDSWRATH, 
				PBMoves::PRECIPICEBLADES, PBMoves::DRAGONASCENT, PBMoves::MOONGEISTBEAM, 
				PBMoves::SUNSTEELSTRIKE, PBMoves::PRISMATICLASER, PBMoves::FLEURCANNON, 
				PBMoves::DIAMONDSTORM, PBMoves::GENESISSUPERNOVA, PBMoves::SEARINGSUNRAZESMASH,
				PBMoves::MENACINGMOONRAZEMAELSTROM],
		1.5 => [PBMoves::MYSTICALFIRE, PBMoves::MAGICALLEAF, PBMoves::ANCIENTPOWER,PBMoves::JUDGMENT,
			PBMoves::SACREDFIRE, PBMoves::EXTREMESPEED, PBMoves::SACREDSWORD,PBMoves::RETURN]},
		:MOVEMESSAGES => {
		"Legendary power accelerated the attack!" => [PBMoves::PSYSTRIKE, 
			PBMoves::AEROBLAST, PBMoves::SACREDFIRE, PBMoves::ORIGINPULSE, PBMoves::DOOMDUMMY, 
			PBMoves::JUDGMENT, PBMoves::MISTBALL, PBMoves::CRUSHGRIP, PBMoves::LUSTERPURGE, 
			PBMoves::SECRETSWORD, PBMoves::PSYCHOBOOST, PBMoves::RELICSONG, PBMoves::SPACIALREND, 
			PBMoves::HYPERSPACEHOLE, PBMoves::ROAROFTIME, PBMoves::LANDSWRATH, 
			PBMoves::PRECIPICEBLADES, PBMoves::DRAGONASCENT, PBMoves::MOONGEISTBEAM, 
			PBMoves::SUNSTEELSTRIKE, PBMoves::PRISMATICLASER, PBMoves::FLEURCANNON, 
			PBMoves::DIAMONDSTORM, PBMoves::GENESISSUPERNOVA, PBMoves::SEARINGSUNRAZESMASH,
			PBMoves::MENACINGMOONRAZEMAELSTROM],
		"The holy energy resonated with the attack!" => [PBMoves::MYSTICALFIRE, 
			PBMoves::MAGICALLEAF, PBMoves::ANCIENTPOWER, PBMoves::SACREDSWORD,PBMoves::RETURN],
		"Godspeed!" => [PBMoves::EXTREMESPEED]},
		:TYPEDAMAGEBOOST => {
		1.5 => [PBTypes::FAIRY,PBTypes::NORMAL],
		1.2 => [PBTypes::PSYCHIC,PBTypes::DRAGON],
		0.5 => [PBTypes::GHOST,PBTypes::DARK]},
		:TYPEMESSAGES => {
		"The holy energy resonated with the attack!" => [PBTypes::FAIRY,PBTypes::NORMAL],
		"The legendary energy resonated with the attack!" => [PBTypes::PSYCHIC,PBTypes::DRAGON],
		"The attack was cleansed..." => [PBTypes::GHOST,PBTypes::DARK]},
		:TYPECONDITION => {
			PBTypes::FAIRY => "self.pbIsSpecial?(type)",
			PBTypes::NORMAL => "self.pbIsSpecial?(type)",
			PBTypes::DARK => "self.pbIsSpecial?(type)"
		},
		:FIELDCHANGE => {0 => [PBMoves::LIGHTTHATBURNSTHESKY]},
		:CHANGEMESSAGE => {"The holy light was consumed!" => [PBMoves::LIGHTTHATBURNSTHESKY]},
		:STATUSMOVEBOOST => [PBMoves::WISH, PBMoves::MIRACLEEYE, PBMoves::COSMICPOWER, PBMoves::NATURESMADNESS],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::MAGICALSEED,
		:SEEDEFFECT => PBEffects::MagicCoat,
		:SEEDEFFECTVAL => true,
		:SEEDEFFECTSTR => "{1} shrouded itself with Magic Coat!",
		:SEEDANIM => PBMoves::MAGICCOAT,
		:SEEDSTATS => {PBStats::SPATK => 1}
		},
	# 30 Mirror Arena
	PBFields::MIRRORA => {
    	:FIELDNAME => "Mirror Arena",  
    	:INTROMESSAGE => ["Mirror, mirror, on the field,","Who shall this fractured power wield?"],
		:FIELDGRAPHICS =>  "Mirror",
		:SECRETPOWERANIM => PBMoves::MIRRORSHOT,
		:NATUREMOVES => PBMoves::MIRRORSHOT,
		:MIMICRY => PBTypes::STEEL,
		:MOVEDAMAGEBOOST => {
		1.5 => PBFields::BLINDINGMOVES,
		2.0 => [PBMoves::MIRRORSHOT]},
		:MOVEMESSAGES => {
		"The reflected light was blinding!" => PBFields::BLINDINGMOVES,
		"The mirrors strengthened the attack!" => [PBMoves::MIRRORSHOT]},
		:FIELDCHANGE => {
		0 => PBFields::QUAKEMOVES + [PBMoves::BOOMBURST, PBMoves::HYPERVOICE, PBMoves::SELFDESTRUCT,
			 PBMoves::EXPLOSION]},
		:STATUSMOVEBOOST => [PBMoves::LIGHTSCREEN, PBMoves::AURORAVEIL, PBMoves::REFLECT, PBMoves::MIRRORMOVE,
		PBMoves::MIRRORCOAT, PBMoves::DOUBLETEAM, PBMoves::FLASH],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::SYNTHETICSEED,
		:SEEDEFFECT => PBEffects::MagicCoat,
		:SEEDEFFECTVAL => true,
		:SEEDEFFECTSTR => "{1} shrouded itself with Magic Coat!",
		:SEEDANIM => PBMoves::MAGICCOAT,
		:SEEDSTATS => {PBStats::EVASION => 1}
		},
	# 31 Fairy Tale Field
	PBFields::FAIRYTALEF => {
		:FIELDNAME => "Fairy Tale Field",
		:INTROMESSAGE => "Once upon a time...",
		:FIELDGRAPHICS =>  "FairyTale",
		:SECRETPOWERANIM => PBMoves::SLASH,
		:NATUREMOVES => PBMoves::SECRETSWORD,
		:MIMICRY => PBTypes::FAIRY,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::NIGHTSLASH, PBMoves::LEAFBLADE, PBMoves::PSYCHOCUT, 
						PBMoves::SMARTSTRIKE, PBMoves::AIRSLASH, PBMoves::SOLARBLADE, PBMoves::MAGICALLEAF, 
						PBMoves::MYSTICALFIRE, PBMoves::ANCIENTPOWER, PBMoves::RELICSONG, 
						PBMoves::SPARKLINGARIA, PBMoves::MOONGEISTBEAM, PBMoves::FLEURCANNON,
						PBMoves::OCEANICOPERETTA, PBMoves::MENACINGMOONRAZEMAELSTROM],
		2.0 => [PBMoves::DRAININGKISS]},
		:MOVEMESSAGES => {
		"The blade cuts true!" => [PBMoves::NIGHTSLASH, PBMoves::LEAFBLADE, PBMoves::PSYCHOCUT, 
			PBMoves::SMARTSTRIKE, PBMoves::AIRSLASH, PBMoves::SOLARBLADE],
		"The magical energy strengthened the attack!" => [PBMoves::MAGICALLEAF, 
		PBMoves::MYSTICALFIRE, PBMoves::ANCIENTPOWER, PBMoves::RELICSONG, 
		PBMoves::SPARKLINGARIA, PBMoves::MOONGEISTBEAM, PBMoves::FLEURCANNON, PBMoves::OCEANICOPERETTA,
		PBMoves::MENACINGMOONRAZEMAELSTROM],
		"True love never hurt so badly!" => [PBMoves::DRAININGKISS]},
		:TYPETYPEMOD => {PBTypes::DRAGON => [PBTypes::FIRE]},
		:TYPEDAMAGEBOOST => {
		1.5 => [PBTypes::STEEL,PBTypes::FAIRY],
		2.0 => [PBTypes::DRAGON]},
		:TYPEMESSAGES => {
		"For ever after!" => [PBTypes::FAIRY],
		"For justice!" => [PBTypes::STEEL],
		"The foul beast's attack gained strength!" => [PBTypes::DRAGON]},
		:STATUSMOVEBOOST => [PBMoves::KINGSSHIELD, PBMoves::SPIKYSHIELD, PBMoves::CRAFTYSHIELD, PBMoves::FLOWERSHIELD,
			PBMoves::ACIDARMOR, PBMoves::NOBLEROAR, PBMoves::SWORDSDANCE, PBMoves::WISH, PBMoves::HEALINGWISH,
			PBMoves::MIRACLEEYE, PBMoves::FORESTSCURSE, PBMoves::FLORALHEALING],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::MAGICALSEED,
		:SEEDEFFECT => PBEffects::KingsShield,
		:SEEDEFFECTVAL => true,
		:SEEDEFFECTSTR => "The Magical Seed shielded {1} against damage!",
		:SEEDANIM => PBMoves::KINGSSHIELD,
		:SEEDSTATS => {}
		},
	# 32 Dragon's Den
	PBFields::DRAGONSD => {
		:FIELDNAME => "Dragon's Den",
		:INTROMESSAGE => "If you wish to slay a dragon...",
		:FIELDGRAPHICS =>  "DragonsDen",
		:SECRETPOWERANIM => PBMoves::DRAGONPULSE,
		:NATUREMOVES => PBMoves::DRAGONPULSE,
		:MIMICRY => PBTypes::DRAGON,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::MEGAKICK, PBMoves::MAGMASTORM, PBMoves::LAVAPLUME],
		2.0 => [PBMoves::SMACKDOWN, PBMoves::THOUSANDARROWS, PBMoves::DRAGONASCENT, 
						PBMoves::PAYDAY, PBMoves::TECTONICRAGE, PBMoves::CONTINENTALCRUSH]},
		:MOVEMESSAGES => {
		"Trial of the Dragon!!!" => [PBMoves::MEGAKICK], 
		"The lava strengthened the attack!" => [PBMoves::MAGMASTORM, PBMoves::LAVAPLUME],
		"{1} was knocked into the lava!" => [PBMoves::SMACKDOWN, PBMoves::THOUSANDARROWS],
		"The draconic energy boosted the attack!" => [PBMoves::DRAGONASCENT], 
		"money money money money money mothafucka" => [PBMoves::PAYDAY]},
		:MOVETYPEMOD => {PBTypes::FIRE => [PBMoves::SMACKDOWN, PBMoves::THOUSANDARROWS, PBMoves::TECTONICRAGE, PBMoves::CONTINENTALCRUSH]},
		:TYPEDAMAGEBOOST => {
		1.5 => [PBTypes::DRAGON, PBTypes::FIRE],
		0.5 => [PBTypes::ICE,PBTypes::WATER]},
		:TYPEMESSAGES => {
		"The lava's heat boosted the flame!" => [PBTypes::FIRE],
		"The draconic energy boosted the attack!" => [PBTypes::DRAGON],
		"The lava's heat softened the attack..." => [PBTypes::ICE,PBTypes::WATER]},
		:FIELDCHANGE => {PBFields::CAVE => [PBMoves::GLACIATE, PBMoves::SUBZEROSLAMMER, PBMoves::OCEANICOPERETTA, PBMoves::HYDROVORTEX]},
		:CHANGEMESSAGE => {
			"The lava was frozen solid!" => [PBMoves::GLACIATE, PBMoves::SUBZEROSLAMMER],
			"The lava solidified!" => [PBMoves::OCEANICOPERETTA, PBMoves::HYDROVORTEX]},
		:STATUSMOVEBOOST => [PBMoves::DRAGONDANCE, PBMoves::NOBLEROAR],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::ELEMENTALSEED,
		:SEEDEFFECT => PBEffects::FlashFire,
		:SEEDEFFECTVAL => true,
		:SEEDEFFECTSTR => "{1} raised its Fire power!",
		:SEEDANIM => 0,
		:SEEDSTATS => {PBStats::SPATK => 1}
		},
	# 33 Flower Garden Field
	PBFields::FLOWERGARDENF => { #fuck
		:FIELDNAME => "Flower Garden Field",
		:INTROMESSAGE => "Seeds line the field.",
		:FIELDGRAPHICS => "FlowerGarden0", #fuck?
		:SECRETPOWERANIM => PBMoves::SWEETSCENT, #fuck
		:NATUREMOVES => PBMoves::GROWTH, #later stages handled in function
		:MIMICRY => PBTypes::GRASS,
		:MOVEDAMAGEBOOST => {}, #fuck
		:MOVEMESSAGES => {}, #fuck
		:FIELDCHANGE => {PBFields::BURNINGF => PBFields::IGNITEMOVES},
		:CHANGEMESSAGE => {"The garden caught fire!" => PBFields::IGNITEMOVES},
		:CHANGECONDITION => {PBFields::BURNINGF => "ignitecheck && @battle.field.counter > 1"},
		:DONTCHANGEBACKUP => PBFields::IGNITEMOVES,
		:STATUSMOVEBOOST => [PBMoves::GROWTH, PBMoves::ROTOTILLER, PBMoves::RAINDANCE, 
		PBMoves::WATERSPORT, PBMoves::SUNNYDAY, PBMoves::FLOWERSHIELD, PBMoves::SWEETSCENT, 
		PBMoves::INGRAIN, PBMoves::FLORALHEALING],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::SYNTHETICSEED,
		:SEEDEFFECT => PBEffects::Ingrain,
		:SEEDEFFECTVAL => true,
		:SEEDEFFECTSTR => "{1} planted its roots!",
		:SEEDANIM => PBMoves::INGRAIN,
		:SEEDSTATS => {PBStats::SPDEF => 1}
		},
	# 34 Starlight Arena
	PBFields::STARLIGHTA => {
		:FIELDNAME => "Starlight Arena",
		:INTROMESSAGE => "Starlight fills the battlefield.",
		:FIELDGRAPHICS =>  "Starlight",
		:SECRETPOWERANIM => PBMoves::SWIFT,
		:NATUREMOVES => PBMoves::MOONBLAST,
		:MIMICRY => PBTypes::DARK,
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::AURORABEAM, PBMoves::SIGNALBEAM, PBMoves::FLASHCANNON, 
				PBMoves::LUSTERPURGE, PBMoves::DAZZLINGGLEAM, PBMoves::MIRRORSHOT, 
				PBMoves::TECHNOBLAST, PBMoves::SOLARBEAM, PBMoves::PHOTONGEYSER, 
				PBMoves::MOONBLAST],
		2.0 => [PBMoves::DRACOMETEOR, PBMoves::METEORMASH, PBMoves::COMETPUNCH, 
				PBMoves::SPACIALREND, PBMoves::SWIFT, PBMoves::HYPERSPACEHOLE, 
				PBMoves::HYPERSPACEFURY, PBMoves::MOONGEISTBEAM, PBMoves::SUNSTEELSTRIKE,
				PBMoves::BLACKHOLEECLIPSE, PBMoves::SEARINGSUNRAZESMASH, PBMoves::MENACINGMOONRAZEMAELSTROM],
		4.0 => [PBMoves::DOOMDUMMY]},
		:MOVEMESSAGES => {
		"Starlight surged through the attack!" => [PBMoves::AURORABEAM, PBMoves::SIGNALBEAM, 
			PBMoves::FLASHCANNON, PBMoves::LUSTERPURGE, PBMoves::DAZZLINGGLEAM, PBMoves::MIRRORSHOT, 
			PBMoves::TECHNOBLAST, PBMoves::SOLARBEAM, PBMoves::PHOTONGEYSER],
		"Lunar energy surged through the attack!" => [PBMoves::MOONBLAST],
		"The astral energy boosted the attack!" => [PBMoves::DRACOMETEOR, PBMoves::METEORMASH, 
			PBMoves::COMETPUNCH, PBMoves::SPACIALREND, PBMoves::SWIFT,  
			PBMoves::HYPERSPACEFURY, PBMoves::MOONGEISTBEAM, PBMoves::SUNSTEELSTRIKE, 
			PBMoves::BLACKHOLEECLIPSE, PBMoves::SEARINGSUNRAZESMASH, PBMoves::MENACINGMOONRAZEMAELSTROM],
		"The astral vortex accelerated the attack!" => [PBMoves::HYPERSPACEHOLE],
		"A star came crashing down!" => [PBMoves::DOOMDUMMY]},
		:MOVETYPEMOD => {PBTypes::FIRE => [PBMoves::DOOMDUMMY]},
		:TYPETYPEMOD => {PBTypes::FAIRY => [PBTypes::DARK]},
		:TYPEDAMAGEBOOST => {
		1.5 => [PBTypes::DARK,PBTypes::PSYCHIC],
		1.3 => [PBTypes::FAIRY]},
		:TYPEMESSAGES => {
		"Starlight supercharged the attack!" => [PBTypes::FAIRY],
		"The night sky boosted the attack!" => [PBTypes::DARK],
		"The astral energy boosted the attack!" => [PBTypes::PSYCHIC]},
		:FIELDCHANGE => {0 => [PBMoves::LIGHTTHATBURNSTHESKY]},
		:CHANGEMESSAGE => {"The cosmic light was consumed!" => [PBMoves::LIGHTTHATBURNSTHESKY]},
		:STATUSMOVEBOOST => [PBMoves::COSMICPOWER, PBMoves::FLASH, PBMoves::WISH, PBMoves::HEALINGWISH, PBMoves::LUNARDANCE, PBMoves::MOONLIGHT],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::MAGICALSEED,
		:SEEDEFFECT => PBEffects::Wish,
		:SEEDEFFECTVAL => 2,
		:SEEDEFFECTSTR => "A wish was made for {1}!",
		:SEEDANIM => PBMoves::WISH,
		:SEEDSTATS => {PBStats::SPATK => 1}
		},
	# 35 New World
	PBFields::NEWW => {
		:FIELDNAME => "New World",
		:INTROMESSAGE => ["From darkness, from stardust,","From memories of eons past and visions yet to come..."],
		:FIELDGRAPHICS =>  "NewWorld",
		:SECRETPOWERANIM => PBMoves::ROAROFTIME,
		:NATUREMOVES => PBMoves::SPACIALREND,
		:MIMICRY => PBTypes::QMARKS, #RNG
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::AURORABEAM, PBMoves::SIGNALBEAM, PBMoves::FLASHCANNON, 
				PBMoves::DAZZLINGGLEAM, PBMoves::MIRRORSHOT, PBMoves::PHOTONGEYSER, 
				PBMoves::PSYSTRIKE, PBMoves::AEROBLAST, PBMoves::SACREDFIRE, PBMoves::MISTBALL, 
				PBMoves::LUSTERPURGE, PBMoves::ORIGINPULSE, PBMoves::PRECIPICEBLADES, 
				PBMoves::DRAGONASCENT, PBMoves::PSYCHOBOOST, PBMoves::ROAROFTIME, 
				PBMoves::MAGMASTORM, PBMoves::CRUSHGRIP, PBMoves::JUDGMENT, PBMoves::SEEDFLARE, 
				PBMoves::SHADOWFORCE, PBMoves::SEARINGSHOT, PBMoves::VCREATE, 
				PBMoves::SECRETSWORD, PBMoves::SACREDSWORD, PBMoves::RELICSONG, 
				PBMoves::FUSIONBOLT, PBMoves::FUSIONFLARE, PBMoves::ICEBURN, 
				PBMoves::FREEZESHOCK, PBMoves::BOLTSTRIKE, PBMoves::BLUEFLARE, 
				PBMoves::TECHNOBLAST, PBMoves::OBLIVIONWING, PBMoves::LANDSWRATH, 
				PBMoves::THOUSANDARROWS, PBMoves::THOUSANDWAVES, PBMoves::DIAMONDSTORM, 
				PBMoves::STEAMERUPTION, PBMoves::COREENFORCER, PBMoves::FLEURCANNON, 
				PBMoves::PRISMATICLASER, PBMoves::SUNSTEELSTRIKE, PBMoves::SPECTRALTHIEF, 
				PBMoves::MOONGEISTBEAM, PBMoves::MULTIATTACK, PBMoves::MINDBLOWN, 
				PBMoves::PLASMAFISTS, PBMoves::EARTHPOWER, PBMoves::POWERGEM, 
				PBMoves::ERUPTION, PBMoves::CONTINENTALCRUSH, PBMoves::GENESISSUPERNOVA,
				PBMoves::SOULSTEALING7STARSTRIKE, PBMoves::SEARINGSUNRAZESMASH,
				PBMoves::MENACINGMOONRAZEMAELSTROM],
		2.0 => [PBMoves::VACUUMWAVE, PBMoves::DRACOMETEOR, PBMoves::METEORMASH, 
				PBMoves::MOONBLAST, PBMoves::COMETPUNCH, PBMoves::SWIFT, 
				PBMoves::HYPERSPACEHOLE, PBMoves::SPACIALREND, PBMoves::HYPERSPACEFURY, 
				PBMoves::ANCIENTPOWER, PBMoves::FUTUREDUMMY, PBMoves::BLACKHOLEECLIPSE],
		4.0 => [PBMoves::DOOMDUMMY],
		0.25 => [PBMoves::EARTHQUAKE, PBMoves::MAGNITUDE, PBMoves::BULLDOZE]},
		:MOVEACCURACYBOOST => {85 => [PBMoves::DARKVOID]},
		:MOVEMESSAGES => {
		"The light shone through the infinite darkness!" => [PBMoves::AURORABEAM, 
			PBMoves::SIGNALBEAM, PBMoves::FLASHCANNON, PBMoves::DAZZLINGGLEAM, 
			PBMoves::MIRRORSHOT, PBMoves::PHOTONGEYSER],
		"The ethereal energy strengthened the attack!" => [PBMoves::PSYSTRIKE, PBMoves::AEROBLAST,
			PBMoves::SACREDFIRE, PBMoves::MISTBALL, PBMoves::LUSTERPURGE, PBMoves::ORIGINPULSE, 
			PBMoves::PRECIPICEBLADES, PBMoves::DRAGONASCENT, PBMoves::PSYCHOBOOST, 
			PBMoves::ROAROFTIME, PBMoves::MAGMASTORM, PBMoves::CRUSHGRIP, PBMoves::JUDGMENT, 
			PBMoves::SEEDFLARE, PBMoves::SHADOWFORCE, PBMoves::SEARINGSHOT, PBMoves::VCREATE, 
			PBMoves::SECRETSWORD, PBMoves::SACREDSWORD, PBMoves::RELICSONG, PBMoves::FUSIONBOLT, 
			PBMoves::FUSIONFLARE, PBMoves::ICEBURN, PBMoves::FREEZESHOCK, PBMoves::BOLTSTRIKE, 
			PBMoves::BLUEFLARE, PBMoves::TECHNOBLAST, PBMoves::OBLIVIONWING, PBMoves::LANDSWRATH, 
			PBMoves::THOUSANDARROWS, PBMoves::THOUSANDWAVES, PBMoves::DIAMONDSTORM, 
			PBMoves::STEAMERUPTION, PBMoves::COREENFORCER, PBMoves::FLEURCANNON, 
			PBMoves::PRISMATICLASER, PBMoves::SUNSTEELSTRIKE, PBMoves::SPECTRALTHIEF, 
			PBMoves::MOONGEISTBEAM, PBMoves::MULTIATTACK, PBMoves::MINDBLOWN, 
			PBMoves::PLASMAFISTS, PBMoves::GENESISSUPERNOVA, PBMoves::SOULSTEALING7STARSTRIKE,
			PBMoves::SEARINGSUNRAZESMASH, PBMoves::MENACINGMOONRAZEMAELSTROM], 
		"The germinal matter amassed in the attack!" => [PBMoves::EARTHPOWER, PBMoves::POWERGEM, 
			PBMoves::ERUPTION, PBMoves::CONTINENTALCRUSH],
		"The astral energy boosted the attack!" => [PBMoves::VACUUMWAVE, PBMoves::DRACOMETEOR, 
			PBMoves::METEORMASH, PBMoves::MOONBLAST, PBMoves::COMETPUNCH, PBMoves::SWIFT, 
			PBMoves::HYPERSPACEHOLE, PBMoves::SPACIALREND, PBMoves::HYPERSPACEFURY, 
			PBMoves::ANCIENTPOWER, PBMoves::FUTUREDUMMY],
		"A star came crashing down on {1}!" => [PBMoves::DOOMDUMMY], 
		"{1} was swallowed up by the void!" => [PBMoves::BLACKHOLEECLIPSE],
		"The unformed land diffused the attack..." => [PBMoves::EARTHQUAKE, 
			PBMoves::MAGNITUDE, PBMoves::BULLDOZE]},
		:MOVETYPEMOD => {PBTypes::FIRE => [PBMoves::DOOMDUMMY]},
		:TYPEDAMAGEBOOST => {1.5 => [PBTypes::DARK]},
		:TYPEMESSAGES => {"Infinity boosted the attack!" => [PBTypes::DARK]},
		:FIELDCHANGE => {PBFields::STARLIGHTA => [PBMoves::GRAVITY, PBMoves::GEOMANCY]},
		:DONTCHANGEBACKUP => [PBMoves::GRAVITY],
		:CHANGEMESSAGE => {
		"The world's matter reformed!" => [PBMoves::GRAVITY],
		"The world was regenerated!" => [PBMoves::GEOMANCY]},
		:STATUSMOVEBOOST => [PBMoves::DARKVOID, PBMoves::HEARTSWAP, PBMoves::TRICKROOM, PBMoves::MAGICROOM, PBMoves::WONDERROOM, PBMoves::COSMICPOWER, PBMoves::FLASH, PBMoves::MOONLIGHT, PBMoves::NATURESMADNESS],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::MAGICALSEED,
		:SEEDEFFECT => PBEffects::HyperBeam,
		:SEEDEFFECTVAL => 1,
		:SEEDEFFECTSTR => "{1} must recharge!",
		:SEEDANIM => 0,
		:SEEDSTATS => {PBStats::ATTACK => 1,PBStats::DEFENSE => 1,PBStats::SPEED => 1,PBStats::SPATK => 1,PBStats::SPDEF => 1}
		},
	# 36 Inverse Field
	PBFields::INVERSEF => {
		:FIELDNAME => "Inverse Field",
		:INTROMESSAGE => "!trats elttaB",
		:FIELDGRAPHICS =>  "Inverse",
		:SECRETPOWERANIM => PBMoves::CONFUSION,
		:NATUREMOVES => PBMoves::TRICKROOM,
		:MIMICRY => PBTypes::NORMAL,
		:MOVEDAMAGEBOOST => {},
		:MOVEMESSAGES => {},
		:FIELDCHANGE => {},
		:CHANGEMESSAGE => {},
		:STATUSMOVEBOOST => [],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::MAGICALSEED,
		:SEEDEFFECT => PBEffects::HyperBeam,
		:SEEDEFFECTVAL => 1,
		:SEEDEFFECTSTR => "{1} must recharge!",
		:SEEDANIM => 0,
		:SEEDSTATS => {PBStats::ATTACK => 1,PBStats::DEFENSE => 1,PBStats::SPEED => 1,PBStats::SPATK => 1,PBStats::SPDEF => 1}
		},
	# 37 Psychic Terrain
	PBFields::PSYCHICT => {
		:FIELDNAME => "Psychic Terrain",
		:INTROMESSAGE => "The field became mysterious!",
		:FIELDGRAPHICS =>  "Psychic",
		:SECRETPOWERANIM => PBMoves::PSYCHIC,
		:NATUREMOVES => PBMoves::PSYCHIC,
		:MIMICRY => PBTypes::PSYCHIC, #easy
		:MOVEDAMAGEBOOST => {
		1.5 => [PBMoves::HEX, PBMoves::MAGICALLEAF, PBMoves::MYSTICALFIRE, 
						PBMoves::MOONBLAST, PBMoves::AURASPHERE, PBMoves::MINDBLOWN]},
		:MOVEACCURACYBOOST => {90 => [PBMoves::HYPNOSIS]},
		:MOVEMESSAGES => {
		"The psychic energy strengthened the attack!" => [PBMoves::HEX, PBMoves::MAGICALLEAF, 
			PBMoves::MYSTICALFIRE, PBMoves::MOONBLAST, PBMoves::AURASPHERE, PBMoves::MINDBLOWN]},
		:TYPEDAMAGEBOOST => {1.5 => [PBTypes::PSYCHIC]},
		:TYPEMESSAGES => {"The Psychic Terrain strengthened the attack!" => [PBTypes::PSYCHIC]},
		:TYPECONDITION => {PBTypes::ELECTRIC => "!attacker.isAirborne?" },
		:FIELDCHANGE => {},
		:CHANGEMESSAGE => {},
		:STATUSMOVEBOOST => [PBMoves::CALMMIND, PBMoves::COSMICPOWER, PBMoves::KINESIS, PBMoves::MEDITATE,
			PBMoves::NASTYPLOT, PBMoves::HYPNOSIS, PBMoves::TELEKINESIS, PBMoves::GRAVITY, PBMoves::MAGICROOM,
			PBMoves::TRICKROOM, PBMoves::WONDERROOM],
		:CHANGEEFFECTS => {},
		:SEED => PBItems::MAGICALSEED,
		:SEEDEFFECT => 0,
		:SEEDEFFECTVAL => 0,
		:SEEDEFFECTSTR => "{1} became confused!",
		:SEEDANIM => 0,
		:SEEDSTATS => {PBStats::SPATK => 2}
		},
	PBFields::INDOORA => {
		:FIELDGRAPHICS =>  "IndoorA",
		:SECRETPOWERANIM => PBMoves::TRIATTACK,
		:NATUREMOVES => PBMoves::TRIATTACK,
		:MIMICRY => PBTypes::NORMAL,
		:CHANGEMESSAGE => {},
		:CHANGEEFFECTS => {},
		:SEED => {}
		},
	PBFields::INDOORB => {
		:FIELDGRAPHICS =>  "IndoorB",
		:SECRETPOWERANIM => PBMoves::TRIATTACK,
		:NATUREMOVES => PBMoves::TRIATTACK,
		:MIMICRY => PBTypes::NORMAL,
		:CHANGEMESSAGE => {},
		:CHANGEEFFECTS => {},
		:SEED => {}
		},
	PBFields::INDOORC => {
		:FIELDGRAPHICS =>  "IndoorC",
		:SECRETPOWERANIM => PBMoves::TRIATTACK,
		:NATUREMOVES => PBMoves::TRIATTACK,
		:MIMICRY => PBTypes::NORMAL,
		:CHANGEMESSAGE => {},
		:CHANGEEFFECTS => {},
		:SEED => {}
		},
	PBFields::CITY => {
		:FIELDGRAPHICS =>  "City",
		:SECRETPOWERANIM => PBMoves::TRIATTACK,
		:NATUREMOVES => PBMoves::TRIATTACK,
		:MIMICRY => PBTypes::NORMAL,
		:CHANGEMESSAGE => {},
		:CHANGEEFFECTS => {},
		:SEED => {}
		},
	PBFields::CITYNEW => {
		:FIELDGRAPHICS =>  "CityNew",
		:SECRETPOWERANIM => PBMoves::TRIATTACK,
		:NATUREMOVES => PBMoves::TRIATTACK,
		:MIMICRY => PBTypes::NORMAL,
		:CHANGEEFFECTS => {},
		:SEED => {}
		} 
}

